/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.module.database.operator;

import cn.org.atool.fluent.mybatis.metadata.DbType;
import java.util.List;
import java.util.Map;
import org.test4j.Logger;
import org.test4j.hamcrest.iassert.impl.CollectionAssert;
import org.test4j.hamcrest.iassert.impl.IntegerAssert;
import org.test4j.hamcrest.iassert.impl.ObjectAssert;
import org.test4j.hamcrest.iassert.intf.ICollectionAssert;
import org.test4j.hamcrest.iassert.intf.INumberAssert;
import org.test4j.hamcrest.iassert.intf.IObjectAssert;
import org.test4j.module.database.enviroment.DBEnvironment;
import org.test4j.module.database.enviroment.DBEnvironmentFactory;
import org.test4j.module.database.operator.ITableOp;
import org.test4j.module.database.operator.InsertOp;
import org.test4j.module.database.proxy.Test4JSqlContext;
import org.test4j.module.database.script.DBHelper;
import org.test4j.module.database.script.SqlRunner;
import org.test4j.tools.IKit;
import org.test4j.tools.commons.StringHelper;
import org.test4j.tools.datagen.IDataMap;

public class TableOp
implements ITableOp {
    private final DBEnvironment env;
    private final String table;

    public TableOp(String table) {
        this(DBEnvironmentFactory.getDefaultDBEnvironment(), table);
    }

    public TableOp(DBEnvironment env, String table) {
        this.env = env;
        this.table = table;
        if (StringHelper.isBlank((String)this.table)) {
            throw new RuntimeException("the table name can't be null.");
        }
    }

    @Override
    public ITableOp clean() {
        Test4JSqlContext.setDbOpStatus(true);
        try {
            String sql = "truncate table " + this.table;
            SqlRunner.execute(this.env, sql);
            this.h2truncate();
            TableOp tableOp = this;
            return tableOp;
        }
        finally {
            Test4JSqlContext.setDbOpStatus(false);
        }
    }

    private void h2truncate() {
        if (this.env.getDbType() != DbType.H2) {
            return;
        }
        String id = this.env.getTableMetaData(this.table).getPkColumn();
        if (id != null) {
            SqlRunner.execute(this.env, String.format("ALTER TABLE %s ALTER COLUMN %s RESTART WITH 1", this.table, id));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ITableOp insert(IDataMap ... datas) {
        if (datas == null || datas.length == 0) {
            return this;
        }
        Test4JSqlContext.setDbOpStatus(true);
        try {
            for (IDataMap map : datas) {
                InsertOp.insertNoException(this.env, this.table, map);
            }
            TableOp tableOp = this;
            return tableOp;
        }
        finally {
            Test4JSqlContext.setDbOpStatus(false);
        }
    }

    @Override
    public ICollectionAssert query() {
        Test4JSqlContext.setDbOpStatus(true);
        try {
            List<Map<String, Object>> list = this.selectData(null);
            CollectionAssert collectionAssert = new CollectionAssert(list);
            return collectionAssert;
        }
        finally {
            Test4JSqlContext.setDbOpStatus(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ICollectionAssert queryList(Class pojo) {
        Test4JSqlContext.setDbOpStatus(true);
        try {
            String query = "select * from " + this.table;
            List list = SqlRunner.queryList(this.env, query, pojo);
            CollectionAssert collectionAssert = new CollectionAssert(list);
            return collectionAssert;
        }
        finally {
            Test4JSqlContext.setDbOpStatus(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public INumberAssert count() {
        Test4JSqlContext.setDbOpStatus(true);
        try {
            String query = "select count(*) from " + this.table;
            Number number = (Number)SqlRunner.query(this.env, query, Object.class);
            IntegerAssert integerAssert = new IntegerAssert(Integer.valueOf(number.intValue()));
            return integerAssert;
        }
        finally {
            Test4JSqlContext.setDbOpStatus(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ITableOp deleteWhere(String where) {
        Test4JSqlContext.setDbOpStatus(true);
        try {
            String sql = String.format("delete from %s where %s", this.table, where);
            SqlRunner.execute(this.env, sql);
            TableOp tableOp = this;
            return tableOp;
        }
        finally {
            Test4JSqlContext.setDbOpStatus(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IObjectAssert queryAs(Class pojo) {
        Test4JSqlContext.setDbOpStatus(true);
        try {
            String query = "select * from " + this.table;
            Object o = SqlRunner.query(this.env, query, pojo);
            ObjectAssert objectAssert = new ObjectAssert(o);
            return objectAssert;
        }
        finally {
            Test4JSqlContext.setDbOpStatus(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ICollectionAssert queryWhere(String where) {
        Test4JSqlContext.setDbOpStatus(true);
        try {
            List<Map<String, Object>> list = this.selectData(where);
            CollectionAssert collectionAssert = new CollectionAssert(list);
            return collectionAssert;
        }
        finally {
            Test4JSqlContext.setDbOpStatus(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ICollectionAssert printAndAssert(String where) {
        Test4JSqlContext.setDbOpStatus(true);
        try {
            List<Map<String, Object>> list = this.selectData(where);
            Logger.info((Object)IKit.json.toJSON(list, true), (Throwable[])new Throwable[0]);
            CollectionAssert collectionAssert = new CollectionAssert(list);
            return collectionAssert;
        }
        finally {
            Test4JSqlContext.setDbOpStatus(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ICollectionAssert queryWhere(Map dataMap) {
        Test4JSqlContext.setDbOpStatus(true);
        try {
            Map param = dataMap;
            if (dataMap instanceof IDataMap) {
                param = ((IDataMap)dataMap).row(0);
            }
            StringBuilder query = new StringBuilder("select * from ");
            query.append(this.table).append(" ");
            String where = DBHelper.getWhereCondition(param);
            query.append(where);
            List list = SqlRunner.queryMapList(this.env, query.toString(), param);
            CollectionAssert collectionAssert = new CollectionAssert(list);
            return collectionAssert;
        }
        finally {
            Test4JSqlContext.setDbOpStatus(false);
        }
    }

    private List<Map<String, Object>> selectData(String where) {
        String _where = StringHelper.isBlank((String)where) ? "" : " where " + where.trim();
        String query = "select * from " + this.table + _where;
        return TableOp.queryData(this.env, query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Map<String, Object>> queryData(DBEnvironment env, String tableAndWhere) {
        Test4JSqlContext.setDbOpStatus(true);
        try {
            if (tableAndWhere.trim().toLowerCase().startsWith("select")) {
                List<Map<String, Object>> list = SqlRunner.queryMapList(env, tableAndWhere);
                return list;
            }
            String query = "select * from " + tableAndWhere;
            List<Map<String, Object>> list = SqlRunner.queryMapList(env, query);
            return list;
        }
        finally {
            Test4JSqlContext.setDbOpStatus(false);
        }
    }
}

