/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.module.database.proxy;

import ch.vorburger.exec.ManagedProcessException;
import ch.vorburger.mariadb4j.DB;
import ch.vorburger.mariadb4j.DBConfiguration;
import ch.vorburger.mariadb4j.DBConfigurationBuilder;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.BasicDataSource;
import org.test4j.Logger;
import org.test4j.module.database.config.DbConfig;
import org.test4j.module.database.proxy.Test4JDataSource;
import org.test4j.tools.commons.DateHelper;
import org.test4j.tools.commons.StringHelper;
import org.test4j.tools.config.ConfigHelper;

public class DataSourceMariaDb4jCreator {
    public static Test4JDataSource createTest4JDataSource(String dataSourceName) {
        try {
            BasicDataSource dataSource = DataSourceMariaDb4jCreator.createDb(dataSourceName);
            return new Test4JDataSource(dataSourceName, (DataSource)dataSource);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static BasicDataSource createDb(String dataSourceName) throws ManagedProcessException {
        String schema = DbConfig.instance().dbSchema(dataSourceName);
        String username = DbConfig.instance().dbUsername(dataSourceName);
        String password = DbConfig.instance().dbPassword(dataSourceName);
        String driver = DbConfig.instance().dbDriver(dataSourceName);
        Logger.warn((Object)("begin to start MariaDB4j: " + DateHelper.currDateTimeStr()), (Throwable[])new Throwable[0]);
        int port = ConfigHelper.getInteger((String)"dataSource.mariaDB4j.port", (int)0);
        DBConfigurationBuilder config = DBConfigurationBuilder.newBuilder().setPort(port);
        DataSourceMariaDb4jCreator.addArgs(config);
        DB mariaDB = DB.newEmbeddedDB((DBConfiguration)config.build());
        mariaDB.start();
        String url = config.getURL(schema);
        Logger.warn((Object)("MariaDB4j driver[ " + driver + " ], url[ " + url + " ], username[ " + username + " ], password[ " + password + " ]."), (Throwable[])new Throwable[0]);
        Logger.warn((Object)("end of start MariaDB4j:" + DateHelper.currDateTimeStr()), (Throwable[])new Throwable[0]);
        BasicDataSource dataSource = new BasicDataSource();
        dataSource.setDriverClassName(driver);
        dataSource.setUrl(url);
        dataSource.setUsername(username);
        dataSource.setPassword(password);
        return dataSource;
    }

    private static void addArgs(DBConfigurationBuilder config) {
        String[] items;
        String args = ConfigHelper.getString((String)"dataSource.mariaDB4j.args");
        if (StringHelper.isBlank((String)args)) {
            return;
        }
        for (String item : items = args.split(";")) {
            if (StringHelper.isBlank((String)item)) continue;
            config.addArg(item);
        }
    }
}

