/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.module.database.proxy;

import com.wix.mysql.EmbeddedMysql;
import com.wix.mysql.config.AdditionalConfig;
import com.wix.mysql.config.Charset;
import com.wix.mysql.config.DownloadConfig;
import com.wix.mysql.config.MysqldConfig;
import com.wix.mysql.config.ProxyFactory;
import com.wix.mysql.config.SchemaConfig;
import com.wix.mysql.distribution.Version;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.test4j.module.database.config.DbConfig;

public class EmbeddedMysqlConfig {
    private static final Map<String, EmbeddedMysql> started = new ConcurrentHashMap<String, EmbeddedMysql>();
    public final Version version;
    public final int port;
    public final String schema;
    public final String userName = "test";
    public final String password = "password";

    public EmbeddedMysqlConfig() {
        this(DbConfig.instance().embeddedMysqlVersion(), DbConfig.instance().embeddedMysqlPort(), "ut");
    }

    public EmbeddedMysqlConfig(Version version, int port, String schema) {
        this.version = version;
        this.port = port;
        this.schema = schema;
    }

    public EmbeddedMysqlConfig start() {
        EmbeddedMysqlConfig.start(this);
        return this;
    }

    private static synchronized void start(EmbeddedMysqlConfig creator) {
        if (started.containsKey(creator.schema)) {
            return;
        }
        MysqldConfig config = EmbeddedMysqlConfig.getMysqlConfig(creator);
        SchemaConfig schemaConfig = SchemaConfig.aSchemaConfig((String)creator.schema).build();
        AdditionalConfig[] configs = EmbeddedMysqlConfig.getDownloadConfig();
        EmbeddedMysql mysql = EmbeddedMysql.anEmbeddedMysql((MysqldConfig)config, (AdditionalConfig[])configs).addSchema(schemaConfig).start();
        started.put(creator.schema, mysql);
        Runtime.getRuntime().addShutdownHook(new Thread(() -> EmbeddedMysqlConfig.stop(creator.schema)));
    }

    private static AdditionalConfig[] getDownloadConfig() {
        String host = DbConfig.instance().embeddedMysqlRemoteHost();
        if (host.trim().isEmpty()) {
            return new AdditionalConfig[0];
        }
        int port = DbConfig.instance().embeddedMysqlRemotePort();
        DownloadConfig config = DownloadConfig.aDownloadConfig().withProxy(ProxyFactory.aHttpProxy((String)host, (int)port)).build();
        return new AdditionalConfig[]{config};
    }

    private static MysqldConfig getMysqlConfig(EmbeddedMysqlConfig creator) {
        return MysqldConfig.aMysqldConfig((Version)creator.version).withCharset(Charset.UTF8).withPort(creator.port).withUser(creator.userName, creator.password).withTimeZone("Asia/Shanghai").withTimeout(2L, TimeUnit.MINUTES).withServerVariable("max_connect_errors", 100).build();
    }

    public static void stop() {
        Iterator<Map.Entry<String, EmbeddedMysql>> it = started.entrySet().iterator();
        while (it.hasNext()) {
            it.next().getValue().stop();
            it.remove();
        }
    }

    public static void stop(String schema) {
        if (started.containsKey(schema)) {
            started.get(schema).stop();
            started.remove(schema);
        }
    }

    public String url() {
        return String.format("jdbc:mysql://localhost:%d/%s?characterEncoding=UTF-8&zeroDateTimeBehavior=convertToNull&allowMultiQueries=true", this.port, this.schema);
    }
}

