/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.module.database.proxy.db;

import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.h2.command.Command;
import org.h2.jdbc.JdbcPreparedStatement;
import org.test4j.module.database.proxy.Test4JSqlContext;
import org.test4j.tools.IKit;
import org.test4j.tools.commons.ClazzHelper;
import org.test4j.tools.reflector.FieldAccessor;

public class H2Statement {
    private static final String H2_Statement_Class = "org.h2.jdbc.JdbcPreparedStatement";

    public static boolean isH2PreparedStatement(Statement statement) {
        boolean available = ClazzHelper.isClassAvailable((String)H2_Statement_Class);
        if (!available) {
            return false;
        }
        Class klass = ClazzHelper.getClazz((String)H2_Statement_Class);
        return statement.getClass().isAssignableFrom(klass);
    }

    public static void addSql(Statement statement) {
        JdbcPreparedStatement h2statment = (JdbcPreparedStatement)statement;
        Command command = (Command)FieldAccessor.getValue((Object)h2statment, (String)"command");
        String sql = (String)FieldAccessor.getValue((Object)command, (String)"sql");
        String str = command.toString();
        if (str.contains(sql)) {
            int index = str.indexOf(sql);
            try {
                String parameters = str.substring(index + sql.length());
                Map map = (Map)IKit.json.toObject(parameters, HashMap.class);
                ArrayList list = new ArrayList();
                for (int loop = 0; loop < map.size(); ++loop) {
                    list.add(map.get(index));
                }
                Test4JSqlContext.addSql(sql, list.toArray());
            }
            catch (Exception e) {
                Test4JSqlContext.addSql(sql, new Object[0]);
            }
        } else {
            Test4JSqlContext.addSql(sql, new Object[0]);
        }
    }
}

