/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.module.database.script;

import cn.org.atool.fluent.mybatis.metadata.DbType;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.test4j.module.database.annotations.ColumnDef;
import org.test4j.module.database.annotations.ScriptTable;
import org.test4j.module.database.script.script.DerbyScript;
import org.test4j.module.database.script.script.H2Script;
import org.test4j.module.database.script.script.HSqlScript;
import org.test4j.module.database.script.script.MysqlScript;
import org.test4j.module.database.script.script.PostgreScript;
import org.test4j.module.database.script.script.SqliteScript;
import org.test4j.tools.commons.AnnotationHelper;
import org.test4j.tools.commons.StringHelper;

public abstract class EntityScriptParser {
    protected static final String NEW_LINE_JOIN = ",\n\t";
    protected final Class klass;
    protected final DbTypeConvert typeConvert;

    public EntityScriptParser(DbTypeConvert typeConvert, Class klass) {
        this.typeConvert = typeConvert == null ? new NonDbTypeConvert() : typeConvert;
        this.klass = klass;
    }

    public static String script(DbType type, DbTypeConvert typeConvert, List<Class> classes) {
        return classes.stream().map(klass -> EntityScriptParser.newScriptParser(type, typeConvert, klass)).map(EntityScriptParser::script).collect(Collectors.joining("\n\n"));
    }

    protected static EntityScriptParser newScriptParser(DbType type, DbTypeConvert typeConvert, Class klass) {
        switch (type) {
            case H2: {
                return new H2Script(typeConvert, klass);
            }
            case SQLITE: {
                return new SqliteScript(typeConvert, klass);
            }
            case HSQL: {
                return new HSqlScript(typeConvert, klass);
            }
            case DERBY: {
                return new DerbyScript(typeConvert, klass);
            }
            case MYSQL: 
            case MARIADB: {
                return new MysqlScript(typeConvert, klass);
            }
            case POSTGRE_SQL: {
                return new PostgreScript(typeConvert, klass);
            }
        }
        throw new RuntimeException("not support!");
    }

    public String script() {
        List<ColumnDefine> columns = this.findColumns();
        String table = this.dbType().wrap(this.getTableName());
        StringBuilder buff = new StringBuilder().append(String.format("DROP TABLE IF EXISTS %s;\n", table)).append(String.format("CREATE TABLE %s (\n\t", table)).append(this.parseColumn(columns));
        return buff.append(");\n").toString();
    }

    public DbType dbType() {
        return DbType.OTHER;
    }

    protected String findPrimaryFieldNames(List<ColumnDefine> columns) {
        return columns.stream().filter(column -> column.primary).map(column -> column.name).collect(Collectors.joining(","));
    }

    protected List<ColumnDefine> findColumns() {
        Set annotations = AnnotationHelper.getFieldsAnnotatedWith((Class)this.klass, ColumnDef.class);
        if (annotations != null && !annotations.isEmpty()) {
            return annotations.stream().map(ColumnDefine::new).collect(Collectors.toList());
        }
        throw new RuntimeException("the entity[" + this.klass.getName() + "] field should be defined by @ColumnDef");
    }

    protected String parseColumn(List<ColumnDefine> columns) {
        return columns.stream().map(this::parseColumn).collect(Collectors.joining(NEW_LINE_JOIN));
    }

    protected abstract String parseColumn(ColumnDefine var1);

    protected String convertColumnType(String type) {
        String _type = this.typeConvert.convertType(type);
        return _type == null ? type : _type;
    }

    protected String getTableName() {
        ScriptTable annotation = (ScriptTable)AnnotationHelper.getClassLevelAnnotation(ScriptTable.class, (Class)this.klass);
        if (annotation == null) {
            throw new RuntimeException("the entity class[" + this.klass.getName() + "] should be defined by @ScriptTable");
        }
        return annotation.value();
    }

    protected String getDefaultValue(ColumnDefine column) {
        return column.defaultValue;
    }

    protected static DbTypeConvert typeConvert(DbTypeConvert outerTypeConvert, DbTypeConvert innerTypeConvert) {
        return outerTypeConvert == NonDbTypeConvert.INSTANCE ? innerTypeConvert : outerTypeConvert;
    }

    public static class NonDbTypeConvert
    implements DbTypeConvert {
        public static final DbTypeConvert INSTANCE = new NonDbTypeConvert();
        protected final Map<String, String> types = new HashMap<String, String>();

        protected NonDbTypeConvert() {
        }

        @Override
        public String convertType(String type) {
            String uType = this.mapping(type);
            if (uType != null) {
                return uType;
            }
            String rType = this.regex(type.toUpperCase().replaceAll("\\s+", " ").trim());
            if (rType != null) {
                return rType;
            }
            return type;
        }

        protected String mapping(String type) {
            String uType = type.toUpperCase();
            return this.types.get(uType);
        }

        protected String regex(String type) {
            return null;
        }

        protected boolean isEndsUnsigned(String type) {
            return type.endsWith(" UNSIGNED");
        }

        protected String trimUnsigned(String type) {
            return type.substring(0, type.length() - "UNSIGNED".length());
        }
    }

    public static interface DbTypeConvert {
        public String convertType(String var1);
    }

    public static class ColumnDefine {
        public String name;
        public String type;
        public boolean primary;
        public boolean autoIncrease;
        public boolean notNull;
        public String defaultValue;

        public ColumnDefine(Field field) {
            this.name = StringHelper.camel((String)field.getName());
            ColumnDef def = field.getAnnotation(ColumnDef.class);
            if (def == null) {
                throw new RuntimeException("the field[" + field.getName() + "] should be defined by @ColumnDef");
            }
            this.init(def);
        }

        private void init(ColumnDef def) {
            if (StringHelper.notBlank((String)def.value())) {
                this.name = def.value();
            }
            this.type = def.type();
            this.primary = def.primary();
            this.autoIncrease = def.autoIncrease();
            this.notNull = def.notNull();
            this.defaultValue = def.defaultValue();
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setType(String type) {
            this.type = type;
        }

        public void setPrimary(boolean primary) {
            this.primary = primary;
        }

        public void setAutoIncrease(boolean autoIncrease) {
            this.autoIncrease = autoIncrease;
        }

        public void setNotNull(boolean notNull) {
            this.notNull = notNull;
        }

        public void setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
        }
    }
}

