/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.module.database.script.script;

import cn.org.atool.fluent.mybatis.metadata.DbType;
import org.test4j.module.database.script.EntityScriptParser;
import org.test4j.tools.commons.StringHelper;

public class MysqlScript
extends EntityScriptParser {
    public MysqlScript(EntityScriptParser.DbTypeConvert typeConvert, Class klass) {
        super(typeConvert, klass);
    }

    @Override
    public String script() {
        String sql = super.script().trim();
        return sql.substring(0, sql.length() - 1) + " ENGINE = InnoDB DEFAULT CHARSET = UTF8MB4;\n";
    }

    @Override
    protected String parseColumn(EntityScriptParser.ColumnDefine column) {
        StringBuilder buff = new StringBuilder();
        buff.append(this.dbType().wrap(column.name)).append(" ").append(this.convertColumnType(column.type)).append(" ").append(column.notNull || column.primary ? "not null " : "null ");
        if (!StringHelper.isBlank((String)column.defaultValue)) {
            buff.append("default ").append(super.getDefaultValue(column)).append(" ");
        }
        if (column.autoIncrease) {
            buff.append("auto_increment ");
        }
        if (column.primary) {
            buff.append("primary key");
        }
        return buff.toString().trim();
    }

    @Override
    public DbType dbType() {
        return DbType.MYSQL;
    }
}

