/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.generator.config.impl;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.test4j.generator.db.DbType;
import org.test4j.generator.db.IDbQuery;
import org.test4j.generator.db.ITypeConvert;

public class DbConfig {
    private DbType dbType;
    private String driverName;
    private String url;
    private String username;
    private String password;
    private String schemaName;
    private IDbQuery dbQuery;
    private ITypeConvert typeConvert;
    private Connection connection;

    public DbConfig() {
    }

    public DbConfig(DbType dbType, String driverName, String url, String username, String password) {
        if (url == null) {
            throw new RuntimeException("\u8bf7\u8bbe\u7f6e\u6570\u636e\u5e93\u94fe\u63a5\u4fe1\u606f url");
        }
        this.dbType = dbType;
        this.driverName = driverName;
        this.url = url;
        this.username = username;
        this.password = password;
    }

    public IDbQuery getDbQuery() {
        if (null == this.dbQuery) {
            this.dbQuery = this.dbType.newQuery();
        }
        return this.dbQuery;
    }

    public ITypeConvert getTypeConvert() {
        if (null == this.typeConvert) {
            this.typeConvert = this.dbType.newConvert();
        }
        return this.typeConvert;
    }

    public DbType getDbType() {
        if (null == this.dbType) {
            this.dbType = DbType.getDbType(this.driverName);
            if (null == this.dbType) {
                this.dbType = DbType.getDbType(this.url.toLowerCase());
            }
            if (null == this.dbType) {
                throw new RuntimeException("Unknown type of database!");
            }
        }
        return this.dbType;
    }

    public Connection getConn() {
        if (this.connection == null) {
            try {
                Class.forName(this.driverName);
                return DriverManager.getConnection(this.url, this.username, this.password);
            }
            catch (ClassNotFoundException | SQLException e) {
                throw new RuntimeException("getConn error:" + e.getMessage(), e);
            }
        }
        return this.connection;
    }

    public String getDriverName() {
        return this.driverName;
    }

    public String getUrl() {
        return this.url;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public DbConfig setDbType(DbType dbType) {
        this.dbType = dbType;
        return this;
    }

    public DbConfig setDriverName(String driverName) {
        this.driverName = driverName;
        return this;
    }

    public DbConfig setUrl(String url) {
        this.url = url;
        return this;
    }

    public DbConfig setUsername(String username) {
        this.username = username;
        return this;
    }

    public DbConfig setPassword(String password) {
        this.password = password;
        return this;
    }

    public DbConfig setSchemaName(String schemaName) {
        this.schemaName = schemaName;
        return this;
    }

    public DbConfig setTypeConvert(ITypeConvert typeConvert) {
        this.typeConvert = typeConvert;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DbConfig)) {
            return false;
        }
        DbConfig other = (DbConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        DbType this$dbType = this.getDbType();
        DbType other$dbType = other.getDbType();
        if (this$dbType == null ? other$dbType != null : !((Object)((Object)this$dbType)).equals((Object)other$dbType)) {
            return false;
        }
        String this$driverName = this.getDriverName();
        String other$driverName = other.getDriverName();
        if (this$driverName == null ? other$driverName != null : !this$driverName.equals(other$driverName)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$schemaName = this.getSchemaName();
        String other$schemaName = other.getSchemaName();
        if (this$schemaName == null ? other$schemaName != null : !this$schemaName.equals(other$schemaName)) {
            return false;
        }
        IDbQuery this$dbQuery = this.getDbQuery();
        IDbQuery other$dbQuery = other.getDbQuery();
        if (this$dbQuery == null ? other$dbQuery != null : !this$dbQuery.equals(other$dbQuery)) {
            return false;
        }
        ITypeConvert this$typeConvert = this.getTypeConvert();
        ITypeConvert other$typeConvert = other.getTypeConvert();
        if (this$typeConvert == null ? other$typeConvert != null : !this$typeConvert.equals(other$typeConvert)) {
            return false;
        }
        Connection this$connection = this.connection;
        Connection other$connection = other.connection;
        return !(this$connection == null ? other$connection != null : !this$connection.equals(other$connection));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DbConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        DbType $dbType = this.getDbType();
        result = result * 59 + ($dbType == null ? 43 : ((Object)((Object)$dbType)).hashCode());
        String $driverName = this.getDriverName();
        result = result * 59 + ($driverName == null ? 43 : $driverName.hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $schemaName = this.getSchemaName();
        result = result * 59 + ($schemaName == null ? 43 : $schemaName.hashCode());
        IDbQuery $dbQuery = this.getDbQuery();
        result = result * 59 + ($dbQuery == null ? 43 : $dbQuery.hashCode());
        ITypeConvert $typeConvert = this.getTypeConvert();
        result = result * 59 + ($typeConvert == null ? 43 : $typeConvert.hashCode());
        Connection $connection = this.connection;
        result = result * 59 + ($connection == null ? 43 : $connection.hashCode());
        return result;
    }

    public String toString() {
        return "DbConfig(dbType=" + (Object)((Object)this.getDbType()) + ", driverName=" + this.getDriverName() + ", url=" + this.getUrl() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ", schemaName=" + this.getSchemaName() + ", dbQuery=" + this.getDbQuery() + ", typeConvert=" + this.getTypeConvert() + ", connection=" + this.connection + ")";
    }
}

