/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.generator.config.impl;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.test4j.generator.config.ITableSetter;
import org.test4j.generator.config.constant.DefinedColumn;
import org.test4j.generator.config.constant.Naming;
import org.test4j.generator.config.constant.OutputDir;
import org.test4j.generator.config.impl.DbConfig;
import org.test4j.generator.config.impl.GlobalConfig;
import org.test4j.generator.config.impl.TableConfigSet;
import org.test4j.generator.config.impl.TableField;
import org.test4j.generator.db.DateType;
import org.test4j.generator.db.DbType;
import org.test4j.generator.db.IDbQuery;
import org.test4j.generator.db.IFieldCategory;
import org.test4j.tools.commons.StringHelper;

public class TableSetter
implements ITableSetter {
    private String tableName;
    private DateType dateType = DateType.ONLY_DATE;
    private String[] tablePrefix;
    private String matchedPrefix = "";
    private String entityPrefix;
    private boolean isPartition = false;
    private String seqName;
    private Map<String, DefinedColumn> columns = new HashMap<String, DefinedColumn>();
    private String comment;
    private List<TableField> fields = new ArrayList<TableField>();
    private String fieldNames;
    private final GlobalConfig globalConfig;
    private final TableConfigSet tableConfig;
    private final Set<String> importTypes = new HashSet<String>();
    private Map<IFieldCategory, String> fileTypeName = new HashMap<IFieldCategory, String>();
    private String gmtCreate;
    private String gmtModified;
    private String logicDeleted;
    private static final String NOW = "now()";
    private transient boolean haveId = false;
    private List<Class> baseDaoInterfaces = new ArrayList<Class>();
    private List<Class> entityInterfaces = new ArrayList<Class>();
    private String mapperBeanPrefix = "";
    private Map<String, Object> context;

    @Override
    public ITableSetter enablePartition() {
        this.isPartition = true;
        return this;
    }

    public TableSetter(String tableName, GlobalConfig globalConfig, TableConfigSet tableConfig) {
        this(tableName, null, globalConfig, tableConfig);
    }

    public TableSetter(String tableName, String entityPrefix, GlobalConfig globalConfig, TableConfigSet tableConfig) {
        this.tableName = tableName;
        this.entityPrefix = entityPrefix;
        this.globalConfig = globalConfig;
        this.tableConfig = tableConfig;
    }

    @Override
    public ITableSetter setTablePrefix(String ... tablePrefix) {
        if (!this.hasPrefix()) {
            this.tablePrefix = tablePrefix;
        }
        return this;
    }

    @Override
    public ITableSetter setColumn(String gmtCreate, String gmtModified, String logicDeleted) {
        this.setGmtCreate(gmtCreate);
        this.setGmtModified(gmtModified);
        this.setLogicDeleted(logicDeleted);
        return this;
    }

    @Override
    public ITableSetter setGmtCreate(String gmtCreate) {
        if (StringHelper.isBlank((String)gmtCreate) || !StringHelper.isBlank((String)this.gmtCreate)) {
            return this;
        }
        this.gmtCreate = gmtCreate;
        this.setColumn(this.gmtCreate, (DefinedColumn f) -> f.setInsert(NOW));
        return this;
    }

    @Override
    public ITableSetter setGmtModified(String gmtModified) {
        if (StringHelper.isBlank((String)gmtModified) || !StringHelper.isBlank((String)this.gmtModified)) {
            return this;
        }
        this.gmtModified = gmtModified;
        this.setColumn(this.gmtModified, (DefinedColumn f) -> f.setInsert(NOW).setUpdate(NOW));
        return this;
    }

    @Override
    public ITableSetter setLogicDeleted(String logicDeleted) {
        if (StringHelper.isBlank((String)logicDeleted) || !StringHelper.isBlank((String)this.logicDeleted)) {
            return this;
        }
        this.logicDeleted = logicDeleted;
        this.setColumn(this.logicDeleted, (DefinedColumn f) -> f.setJavaType(Boolean.class).setInsert("0"));
        return this;
    }

    @Override
    public ITableSetter setColumn(String columnName, String propertyName) {
        this.getDefinedColumn(columnName).setFieldName(propertyName);
        return this;
    }

    @Override
    public ITableSetter setColumn(String column, Consumer<DefinedColumn> consumer) {
        DefinedColumn definedColumn = this.getDefinedColumn(column);
        consumer.accept(definedColumn);
        return this;
    }

    private DefinedColumn getDefinedColumn(String column) {
        if (StringHelper.isBlank((String)column)) {
            throw new RuntimeException("the column can't be null.");
        }
        if (!this.columns.containsKey(column)) {
            this.columns.put(column, new DefinedColumn(column));
        }
        return this.columns.get(column);
    }

    @Override
    public ITableSetter setExcludes(String ... columnNames) {
        for (String column : columnNames) {
            this.columns.put(column, new DefinedColumn(column).setExclude());
        }
        return this;
    }

    private boolean isExclude(String field) {
        DefinedColumn column = this.columns.get(field);
        return column != null && column.isExclude();
    }

    public void initTable() {
        this.initEntityPrefix();
        this.initTableFields();
    }

    private void initEntityPrefix() {
        if (!StringHelper.isBlank((String)this.entityPrefix)) {
            return;
        }
        String prefix = this.getNoPrefixTableName();
        if (this.globalConfig.getTableNaming() == Naming.underline_to_camel) {
            prefix = Naming.underlineToCamel(prefix);
        }
        this.entityPrefix = Naming.capitalFirst(prefix);
    }

    public String getNoPrefixTableName() {
        if (this.hasPrefix()) {
            String noPrefix = Naming.removePrefix(this.tableName, this.tablePrefix);
            this.matchedPrefix = this.tableName.substring(0, this.tableName.length() - noPrefix.length());
            return noPrefix;
        }
        return this.tableName;
    }

    private boolean hasPrefix() {
        return this.tablePrefix != null && this.tablePrefix.length > 0;
    }

    private List<TableField> initTableFields() {
        DbConfig dbConfig = this.globalConfig.getDbConfig();
        DbType dbType = dbConfig.getDbType();
        IDbQuery dbQuery = dbConfig.getDbQuery();
        this.fields = new ArrayList<TableField>();
        String tableFieldsSql = this.buildTableFieldsSql();
        try (PreparedStatement preparedStatement = dbConfig.getConn().prepareStatement(tableFieldsSql);
             ResultSet results = preparedStatement.executeQuery();){
            Set<String> h2PkColumns = this.h2PkColumns();
            while (results.next()) {
                TableField field = this.initTableField(dbType, dbQuery, h2PkColumns, results);
                String fieldName = Optional.ofNullable(field).map(TableField::getColumnName).orElse(null);
                if (field == null || this.isExclude(fieldName)) continue;
                if (!field.isPrimary()) {
                    field.setCategory(this.getFieldCategory(fieldName));
                }
                this.fields.add(field);
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("SQL Exception\uff1a" + e.getMessage(), e);
        }
        Collections.sort(this.fields);
        this.fieldNames = this.fields.stream().map(TableField::getColumnName).collect(Collectors.joining(", "));
        return this.fields;
    }

    private IFieldCategory getFieldCategory(String fieldName) {
        if (fieldName.equalsIgnoreCase(this.gmtCreate)) {
            return IFieldCategory.GmtCreate;
        }
        if (fieldName.equalsIgnoreCase(this.gmtModified)) {
            return IFieldCategory.GmtModified;
        }
        if (fieldName.equalsIgnoreCase(this.logicDeleted)) {
            return IFieldCategory.IsDeleted;
        }
        return IFieldCategory.Common;
    }

    private TableField initTableField(DbType dbType, IDbQuery dbQuery, Set<String> h2PkColumns, ResultSet results) throws SQLException {
        boolean primary;
        String columnName = results.getString(dbQuery.fieldName());
        if (this.isExclude(columnName)) {
            return null;
        }
        TableField field = new TableField(this, columnName);
        DefinedColumn defined = this.columns.get(columnName);
        if (defined != null) {
            defined.initField(field);
        }
        if ((primary = this.isPrimary(columnName, results, h2PkColumns)) && !this.haveId) {
            if (DbType.H2 == dbType || DbType.SQLITE == dbType || dbQuery.isKeyIdentity(results)) {
                field.setCategory(IFieldCategory.PrimaryId);
            } else {
                field.setCategory(IFieldCategory.PrimaryKey);
            }
            this.haveId = true;
        }
        field.setJdbcType(results.getString(dbQuery.fieldType()));
        field.initNaming(results);
        return field;
    }

    private boolean isPrimary(String columnName, ResultSet results, Set<String> h2PkColumns) throws SQLException {
        DbConfig dbConfig = this.globalConfig.getDbConfig();
        DbType dbType = dbConfig.getDbType();
        if (DbType.H2 == dbType) {
            return h2PkColumns.contains(columnName);
        }
        IDbQuery dbQuery = dbConfig.getDbQuery();
        String key = results.getString(dbQuery.fieldKey());
        if (DbType.DB2 == dbType || DbType.SQLITE == dbType) {
            return !StringHelper.isBlank((String)key) && "1".equals(key);
        }
        return !StringHelper.isBlank((String)key) && "PRI".equals(key.toUpperCase());
    }

    private String buildTableFieldsSql() {
        DbConfig dbConfig = this.globalConfig.getDbConfig();
        DbType dbType = dbConfig.getDbType();
        IDbQuery dbQuery = dbConfig.getDbQuery();
        String tableFieldsSql = dbQuery.tableFieldsSql();
        switch (dbType) {
            case POSTGRE_SQL: 
            case DB2: {
                return String.format(tableFieldsSql, dbConfig.getSchemaName(), this.tableName);
            }
            case ORACLE: {
                return String.format(tableFieldsSql.replace("#schema", dbConfig.getSchemaName()), this.tableName);
            }
        }
        return String.format(tableFieldsSql, this.tableName);
    }

    private Set<String> h2PkColumns() throws SQLException {
        DbConfig dbConfig = this.globalConfig.getDbConfig();
        HashSet<String> h2PkColumns = new HashSet<String>();
        if (dbConfig.getDbType() != DbType.H2) {
            return h2PkColumns;
        }
        try (PreparedStatement pkQueryStmt = dbConfig.getConn().prepareStatement(String.format("select * from INFORMATION_SCHEMA.INDEXES WHERE TABLE_NAME = '%s'", this.tableName));
             ResultSet pkResults = pkQueryStmt.executeQuery();){
            IDbQuery dbQuery = dbConfig.getDbQuery();
            while (pkResults.next()) {
                String primaryKey = pkResults.getString(dbQuery.fieldKey());
                if (!Boolean.valueOf(primaryKey).booleanValue()) continue;
                h2PkColumns.add(pkResults.getString(dbQuery.fieldName()));
            }
        }
        return h2PkColumns;
    }

    @Override
    public ITableSetter addBaseDaoInterface(Class interfaceType) {
        this.baseDaoInterfaces.add(interfaceType);
        return this;
    }

    private String buildInterfaceName(String interfaceFullName, String[] parameterGenericTypes) {
        int index = interfaceFullName.lastIndexOf(46);
        String typeName = interfaceFullName.substring(index + 1);
        if (parameterGenericTypes != null && parameterGenericTypes.length > 0) {
            typeName = typeName + Stream.of(parameterGenericTypes).collect(Collectors.joining(", ", "<", ">"));
        }
        return typeName;
    }

    @Override
    public ITableSetter addEntityInterface(Class interfaceType) {
        this.entityInterfaces.add(interfaceType);
        return this;
    }

    @Override
    public ITableSetter setMapperPrefix(String mapperBeanPrefix) {
        this.mapperBeanPrefix = mapperBeanPrefix;
        return this;
    }

    public String outputDir(OutputDir dirType) {
        switch (dirType) {
            case Dao: {
                return this.globalConfig.getDaoOutputDir() + this.globalConfig.getDaoDir();
            }
            case Test: {
                return this.globalConfig.getTestOutputDir() + this.globalConfig.getPackageDir();
            }
        }
        return this.globalConfig.getOutputDir() + this.globalConfig.getPackageDir();
    }

    public String getBasePackage() {
        return this.globalConfig.getBasePackage();
    }

    public String getDaoPackage() {
        return this.globalConfig.getDaoPackage();
    }

    public Map<String, Object> initTemplateContext() {
        this.context = new HashMap<String, Object>();
        this.context.put("table", this.getTableName());
        this.context.put("table_no_prefix", this.getNoPrefixTableName());
        this.context.put("entityPrefix", this.getEntityPrefix());
        for (TableField field2 : this.fields) {
            if (!field2.isPrimary()) continue;
            this.context.put("primaryColumnName", field2.getColumnName());
            this.context.put("primaryFieldName", field2.getName());
            break;
        }
        this.context.put("comment", this.getComment());
        this.context.put("fieldNames", this.getFieldNames());
        this.context.put("fields", this.getFields());
        this.context.put("author", this.globalConfig.getAuthor());
        String types = this.fields.stream().map(field -> field.getJavaType().getName()).filter(type -> type != null).distinct().sorted().map(type -> "import " + type + ";").collect(Collectors.joining("\n"));
        this.context.put("importTypes", types);
        return this.context;
    }

    public String getTableName() {
        return this.tableName;
    }

    public DateType getDateType() {
        return this.dateType;
    }

    public String[] getTablePrefix() {
        return this.tablePrefix;
    }

    public String getMatchedPrefix() {
        return this.matchedPrefix;
    }

    public String getEntityPrefix() {
        return this.entityPrefix;
    }

    public boolean isPartition() {
        return this.isPartition;
    }

    public String getSeqName() {
        return this.seqName;
    }

    public Map<String, DefinedColumn> getColumns() {
        return this.columns;
    }

    public String getComment() {
        return this.comment;
    }

    public List<TableField> getFields() {
        return this.fields;
    }

    public String getFieldNames() {
        return this.fieldNames;
    }

    public GlobalConfig getGlobalConfig() {
        return this.globalConfig;
    }

    public TableConfigSet getTableConfig() {
        return this.tableConfig;
    }

    public Set<String> getImportTypes() {
        return this.importTypes;
    }

    public Map<IFieldCategory, String> getFileTypeName() {
        return this.fileTypeName;
    }

    public String getMapperBeanPrefix() {
        return this.mapperBeanPrefix;
    }

    public Map<String, Object> getContext() {
        return this.context;
    }

    public TableSetter setTableName(String tableName) {
        this.tableName = tableName;
        return this;
    }

    public TableSetter setDateType(DateType dateType) {
        this.dateType = dateType;
        return this;
    }

    public TableSetter setEntityPrefix(String entityPrefix) {
        this.entityPrefix = entityPrefix;
        return this;
    }

    @Override
    public TableSetter setSeqName(String seqName) {
        this.seqName = seqName;
        return this;
    }

    public TableSetter setComment(String comment) {
        this.comment = comment;
        return this;
    }

    public List<Class> getBaseDaoInterfaces() {
        return this.baseDaoInterfaces;
    }

    public List<Class> getEntityInterfaces() {
        return this.entityInterfaces;
    }

    public TableSetter setMapperBeanPrefix(String mapperBeanPrefix) {
        this.mapperBeanPrefix = mapperBeanPrefix;
        return this;
    }
}

