/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.generator.convert;

import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.test4j.module.core.utility.MessageHelper;
import org.test4j.tools.commons.ResourceHelper;

public class UnderlineToCapital {
    private static String reg = "(.*\\.)(\\w+_[\\w\\d_]+)(\\.(values|formatAutoIncrease|autoIncrease)\\(.*\\)+;?(.*))";
    private static Pattern pattern = Pattern.compile(reg);

    public static void convertPath(String path) {
        UnderlineToCapital.convertPath(new File(path));
    }

    public static void convertPath(File path) {
        File[] files;
        if (!path.isDirectory() || !path.exists()) {
            MessageHelper.info((Object)"\u6587\u4ef6\u5939\u4e0d\u5b58\u5728", (Throwable[])new Throwable[0]);
            return;
        }
        for (File file : files = path.listFiles()) {
            if (file.isFile()) {
                UnderlineToCapital.convertFile(file);
                MessageHelper.info((Object)("\u8f6c\u6362\u6587\u4ef6[" + file.getName() + "]\u6210\u529f"), (Throwable[])new Throwable[0]);
                continue;
            }
            if (!file.isDirectory()) continue;
            UnderlineToCapital.convertPath(file);
        }
    }

    public static String convertFile(File file) {
        String[] lines = ResourceHelper.readLinesFromFile((File)file);
        StringBuilder buff = new StringBuilder();
        for (String line : lines) {
            buff.append(UnderlineToCapital.convertLine(line));
            buff.append("\n");
        }
        String value = buff.toString();
        ResourceHelper.writeStringToFile((File)file, (String)value);
        return value;
    }

    public static String convertLine(String line) {
        Matcher m = pattern.matcher(line);
        if (!m.matches()) {
            return line;
        }
        return new StringBuffer().append(m.group(1)).append(UnderlineToCapital.underlineToCapital(m.group(2))).append(m.group(3)).toString();
    }

    public static String underlineToCapital(String input) {
        if (input == null) {
            return null;
        }
        StringBuilder buff = new StringBuilder();
        boolean isUnderline = false;
        for (char ch : input.toCharArray()) {
            if (ch == '_') {
                isUnderline = true;
                continue;
            }
            buff.append(isUnderline ? String.valueOf(ch).toUpperCase() : Character.valueOf(ch));
            isUnderline = false;
        }
        return buff.toString();
    }
}

