/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.generator.db;

import org.test4j.generator.db.ITypeConvert;
import org.test4j.generator.db.convert.DB2TypeConvert;
import org.test4j.generator.db.convert.MySqlTypeConvert;
import org.test4j.generator.db.convert.OracleTypeConvert;
import org.test4j.generator.db.convert.PostgreSqlTypeConvert;
import org.test4j.generator.db.convert.SqlServerTypeConvert;
import org.test4j.generator.db.convert.SqliteTypeConvert;
import org.test4j.generator.db.query.AbstractDbQuery;
import org.test4j.generator.db.query.DB2Query;
import org.test4j.generator.db.query.H2Query;
import org.test4j.generator.db.query.MariadbQuery;
import org.test4j.generator.db.query.MySqlQuery;
import org.test4j.generator.db.query.OracleQuery;
import org.test4j.generator.db.query.PostgreSqlQuery;
import org.test4j.generator.db.query.SqlServerQuery;
import org.test4j.generator.db.query.SqliteQuery;

public enum DbType {
    MYSQL("mysql", "MySql\u6570\u636e\u5e93"){

        @Override
        public AbstractDbQuery newQuery() {
            return new MySqlQuery();
        }

        @Override
        public ITypeConvert newConvert() {
            return new MySqlTypeConvert();
        }
    }
    ,
    MARIADB("mariadb", "MariaDB\u6570\u636e\u5e93"){

        @Override
        public AbstractDbQuery newQuery() {
            return new MariadbQuery();
        }

        @Override
        public ITypeConvert newConvert() {
            return new MySqlTypeConvert();
        }
    }
    ,
    ORACLE("oracle", "Oracle\u6570\u636e\u5e93"){

        @Override
        public AbstractDbQuery newQuery() {
            return new OracleQuery();
        }

        @Override
        public ITypeConvert newConvert() {
            return new OracleTypeConvert();
        }
    }
    ,
    DB2("db2", "DB2\u6570\u636e\u5e93"){

        @Override
        public AbstractDbQuery newQuery() {
            return new DB2Query();
        }

        @Override
        public ITypeConvert newConvert() {
            return new DB2TypeConvert();
        }
    }
    ,
    H2("h2", "H2\u6570\u636e\u5e93"){

        @Override
        public AbstractDbQuery newQuery() {
            return new H2Query();
        }

        @Override
        public ITypeConvert newConvert() {
            return new MySqlTypeConvert();
        }
    }
    ,
    SQLITE("sqlite", "SQLite\u6570\u636e\u5e93"){

        @Override
        public AbstractDbQuery newQuery() {
            return new SqliteQuery();
        }

        @Override
        public ITypeConvert newConvert() {
            return new SqliteTypeConvert();
        }

        @Override
        public boolean isCommentSupported() {
            return false;
        }
    }
    ,
    POSTGRE_SQL("postgresql", "Postgre\u6570\u636e\u5e93"){

        @Override
        public AbstractDbQuery newQuery() {
            return new PostgreSqlQuery();
        }

        @Override
        public ITypeConvert newConvert() {
            return new PostgreSqlTypeConvert();
        }
    }
    ,
    SQL_SERVER("sqlserver", "SQLServer\u6570\u636e\u5e93"){

        @Override
        public AbstractDbQuery newQuery() {
            return new SqlServerQuery();
        }

        @Override
        public ITypeConvert newConvert() {
            return new SqlServerTypeConvert();
        }
    };

    private final String db;
    private final String desc;

    public abstract AbstractDbQuery newQuery();

    public abstract ITypeConvert newConvert();

    public boolean isCommentSupported() {
        return true;
    }

    public static DbType getDbType(String driver) {
        DbType[] dbTypes;
        if (driver == null) {
            return MYSQL;
        }
        String temp = driver.toLowerCase();
        for (DbType type : dbTypes = DbType.values()) {
            if (!temp.contains(type.db)) continue;
            return type;
        }
        return MYSQL;
    }

    public String getDb() {
        return this.db;
    }

    public String getDesc() {
        return this.desc;
    }

    private DbType(String db, String desc) {
        this.db = db;
        this.desc = desc;
    }
}

