/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.generator.db.convert;

import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.util.Date;
import org.test4j.generator.db.DateType;
import org.test4j.generator.db.ITypeConvert;

public class DB2TypeConvert
implements ITypeConvert {
    @Override
    public Class processTypeConvert(DateType dateType, String fieldType) {
        String t = fieldType.toLowerCase();
        if (t.contains("char") || t.contains("text") || t.contains("json") || t.contains("enum")) {
            return String.class;
        }
        if (t.contains("bigint")) {
            return Long.class;
        }
        if (t.contains("smallint") || t.contains("int")) {
            return Integer.class;
        }
        if (t.contains("date") || t.contains("time") || t.contains("year") || t.contains("timestamp")) {
            return Date.class;
        }
        if (t.contains("bit")) {
            return Boolean.class;
        }
        if (t.contains("decimal")) {
            return BigDecimal.class;
        }
        if (t.contains("clob")) {
            return Clob.class;
        }
        if (t.contains("blob")) {
            return Blob.class;
        }
        if (t.contains("binary")) {
            return byte[].class;
        }
        if (t.contains("float")) {
            return Float.class;
        }
        if (t.contains("double")) {
            return Double.class;
        }
        return String.class;
    }
}

