/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.generator.db.convert;

import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.Date;
import org.test4j.generator.db.DateType;
import org.test4j.generator.db.ITypeConvert;

public class OracleTypeConvert
implements ITypeConvert {
    @Override
    public Class processTypeConvert(DateType dateType, String fieldType) {
        String t = fieldType.toLowerCase();
        if (t.contains("char")) {
            return String.class;
        }
        if (t.contains("date") || t.contains("timestamp")) {
            switch (dateType) {
                case ONLY_DATE: {
                    return Date.class;
                }
                case SQL_PACK: {
                    return Timestamp.class;
                }
                case TIME_PACK: {
                    return LocalDateTime.class;
                }
            }
        } else {
            if (t.contains("number")) {
                if (t.matches("number\\(+\\d\\)")) {
                    return Integer.class;
                }
                if (t.matches("number\\(+\\d{2}+\\)")) {
                    return Long.class;
                }
                return BigDecimal.class;
            }
            if (t.contains("float")) {
                return Float.class;
            }
            if (t.contains("clob")) {
                return String.class;
            }
            if (t.contains("blob")) {
                return Blob.class;
            }
            if (t.contains("binary")) {
                return byte[].class;
            }
            if (t.contains("raw")) {
                return byte[].class;
            }
        }
        return String.class;
    }
}

