/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.generator.db.convert;

import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import org.test4j.generator.db.DateType;
import org.test4j.generator.db.convert.BaseTypeConvert;

public class SqliteTypeConvert
extends BaseTypeConvert {
    @Override
    public Class processTypeConvert(DateType dateType, String fieldType) {
        String t = fieldType.toLowerCase();
        if (t.contains("bigint")) {
            return Long.class;
        }
        if (t.contains("tinyint(1)") || t.contains("boolean")) {
            return Boolean.class;
        }
        if (t.contains("int")) {
            return Integer.class;
        }
        if (t.contains("text") || t.contains("char") || t.contains("enum")) {
            return String.class;
        }
        if (t.contains("decimal") || t.contains("numeric")) {
            return BigDecimal.class;
        }
        if (t.contains("clob")) {
            return Clob.class;
        }
        if (t.contains("blob")) {
            return Blob.class;
        }
        if (t.contains("float")) {
            return Float.class;
        }
        if (t.contains("double")) {
            return Double.class;
        }
        if (t.contains("date") || t.contains("time") || t.contains("year")) {
            return this.parseDateType(dateType, t);
        }
        return String.class;
    }
}

