/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.generator.impl;

import cn.org.atool.fluent.mybatis.If;
import java.util.Objects;
import java.util.function.Consumer;
import org.apache.ibatis.type.UnknownTypeHandler;
import org.test4j.generator.annotation.Column;
import org.test4j.generator.annotation.Table;
import org.test4j.generator.annotation.Tables;
import org.test4j.generator.config.IGlobalConfig;
import org.test4j.generator.config.IGlobalConfigSet;
import org.test4j.generator.config.ITableSetter;
import org.test4j.generator.config.constant.DefinedColumn;
import org.test4j.generator.db.IFieldCategory;
import org.test4j.generator.impl.GeneratorByApi;
import org.test4j.tools.commons.StringHelper;

public class GeneratorByAnnotation {
    private final Tables tables;
    private final String srcDir;
    private final String testDir;
    private final String daoDir;

    public static void generate(Class clazz) {
        Tables tables = clazz.getAnnotation(Tables.class);
        if (tables.tables().length == 0) {
            throw new RuntimeException("the @Tables Annotation not found.");
        }
        GeneratorByAnnotation generator = new GeneratorByAnnotation(tables);
        IGlobalConfig globalConfig = generator.globalConfig();
        globalConfig.globalConfig(generator.getGlobalConfig(tables)).tables(tc -> {
            for (Table table : tables.tables()) {
                for (String tableName : table.value()) {
                    Consumer<ITableSetter> consumer = generator.getTableConfig(table);
                    tc.table(tableName, consumer);
                }
            }
        }).execute();
    }

    private Consumer<IGlobalConfigSet> getGlobalConfig(Tables tables) {
        return g -> {
            g.setDataSource(tables.url(), tables.username(), tables.password());
            g.setOutputDir(this.srcDir, this.testDir, this.daoDir);
            g.setBasePackage(tables.basePack());
            g.setDaoPackage(tables.basePack());
        };
    }

    private Consumer<ITableSetter> getTableConfig(Table table) {
        return t -> {
            if (table.excludes().length > 0) {
                t.setExcludes(table.excludes());
            }
            t.setGmtCreate(this.value(table.gmtCreated(), this.tables.gmtCreated()));
            t.setGmtModified(this.value(table.gmtModified(), this.tables.gmtModified()));
            t.setLogicDeleted(this.value(table.logicDeleted(), this.tables.logicDeleted()));
            t.setSeqName(table.seqName());
            t.setTablePrefix(this.value(table.tablePrefix(), this.tables.tablePrefix()));
            t.setMapperPrefix(this.value(table.mapperPrefix(), this.tables.mapperPrefix()));
            for (Class dao : table.dao()) {
                t.addBaseDaoInterface(dao);
            }
            for (Class entity : table.entity()) {
                t.addEntityInterface(entity);
            }
            for (Column column : table.columns()) {
                t.setColumn(column.value(), this.getDefinedColumnConsumer((ITableSetter)t, column));
            }
        };
    }

    private Consumer<DefinedColumn> getDefinedColumnConsumer(ITableSetter ts, Column column) {
        return c -> {
            if (column.category() == IFieldCategory.GmtCreate) {
                ts.setGmtCreate(column.value());
            } else if (column.category() == IFieldCategory.GmtModified) {
                ts.setGmtModified(column.value());
            } else if (column.category() == IFieldCategory.IsDeleted) {
                ts.setLogicDeleted(column.value());
            }
            if (If.notBlank((CharSequence)column.property())) {
                c.setFieldName(column.property());
            }
            if (If.notBlank((CharSequence)column.insert())) {
                c.setInsert(column.insert());
            }
            if (If.notBlank((CharSequence)column.update())) {
                c.setUpdate(column.update());
            }
            if (column.isLarge()) {
                c.setLarge();
            }
            if (!Objects.equals(column.javaType(), Object.class)) {
                c.setJavaType(column.javaType());
            }
            if (!Objects.equals(column.typeHandler(), UnknownTypeHandler.class)) {
                c.setTypeHandler(column.typeHandler());
            }
        };
    }

    private IGlobalConfig globalConfig() {
        return GeneratorByApi.build(StringHelper.isNotBlank((String)this.tables.srcDir()), StringHelper.isNotBlank((String)this.tables.testDir()));
    }

    private GeneratorByAnnotation(Tables tables) {
        this.tables = tables;
        this.srcDir = System.getProperty("user.dir") + "/" + tables.srcDir() + "/";
        this.testDir = System.getProperty("user.dir") + "/" + tables.testDir() + "/";
        this.daoDir = System.getProperty("user.dir") + "/" + tables.daoDir() + "/";
    }

    private String value(String value1, String value2) {
        String value = !"$$NOT_DEFINED$$".equals(value1) ? value1 : ("$$NOT_DEFINED$$".equals(value2) ? "" : value2);
        return value;
    }

    private String[] value(String[] value1, String[] value2) {
        String[] value = this.isDefined(value1) ? value1 : (this.isDefined(value2) ? value2 : new String[]{});
        return value;
    }

    private boolean isDefined(String[] value) {
        return value.length != 1 || !Objects.equals(value[0], "$$NOT_DEFINED$$");
    }
}

