/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.generator.template;

import java.util.HashMap;
import java.util.Map;
import org.test4j.generator.config.constant.OutputDir;
import org.test4j.generator.config.impl.TableSetter;

public abstract class BaseTemplate {
    protected String template;
    protected String filePath;
    protected String fileNameReg;
    protected OutputDir outputDir = OutputDir.Base;
    private boolean isPartition = false;
    static final Map<String, String> VAR_MAPPING = new HashMap<String, String>();

    private BaseTemplate() {
    }

    public BaseTemplate(String template, String fileNameReg) {
        this.fileNameReg = fileNameReg;
        this.template = template;
    }

    public final void initContext(TableSetter table, Map<String, Object> parent, Map<String, Object> ctx) {
        this.filePath = table.outputDir(this.outputDir) + this.fileNameReg.replace("*", table.getEntityPrefix());
        ctx.put("name", this.getFileName(table));
        ctx.put("package", this.getPackage(table));
        this.templateConfigs(table, parent, ctx);
    }

    public abstract String getTemplateId();

    protected abstract void templateConfigs(TableSetter var1, Map<String, Object> var2, Map<String, Object> var3);

    protected String getFileName(TableSetter table) {
        int start = this.fileNameReg.lastIndexOf(47);
        int end = this.fileNameReg.lastIndexOf(46);
        return this.fileNameReg.substring(start + 1, end).replace("*", table.getEntityPrefix());
    }

    protected String getPackage(TableSetter table) {
        int index = this.fileNameReg.lastIndexOf(47);
        String sub = "";
        if (index > 0) {
            sub = this.fileNameReg.substring(0, index).replace('/', '.');
        }
        return table.getBasePackage() + "." + sub;
    }

    public static String getConfig(Map<String, Object> context, String key, String _default) {
        String[] keys;
        Object temp = context;
        for (String item : keys = key.split("\\.")) {
            if (!(temp instanceof Map)) {
                throw new RuntimeException("the key[" + key + "] not found.");
            }
            temp = temp.get(item);
        }
        if (temp instanceof String) {
            return (String)temp;
        }
        if (temp == null && _default != null) {
            return _default;
        }
        throw new RuntimeException("the key[" + key + "] not found.");
    }

    protected String replace(String str, Map<String, Object> context, String ... vars) {
        String replaced = str;
        for (String var : vars) {
            if (!VAR_MAPPING.containsKey(var)) continue;
            replaced = replaced.replace(var, BaseTemplate.getConfig(context, VAR_MAPPING.get(var), null));
        }
        return replaced;
    }

    public String getTemplate() {
        return this.template;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public String getFileNameReg() {
        return this.fileNameReg;
    }

    public boolean isPartition() {
        return this.isPartition;
    }

    public BaseTemplate setTemplate(String template) {
        this.template = template;
        return this;
    }

    public BaseTemplate setFilePath(String filePath) {
        this.filePath = filePath;
        return this;
    }

    public BaseTemplate setFileNameReg(String fileNameReg) {
        this.fileNameReg = fileNameReg;
        return this;
    }

    public BaseTemplate setOutputDir(OutputDir outputDir) {
        this.outputDir = outputDir;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseTemplate)) {
            return false;
        }
        BaseTemplate other = (BaseTemplate)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$template = this.getTemplate();
        String other$template = other.getTemplate();
        if (this$template == null ? other$template != null : !this$template.equals(other$template)) {
            return false;
        }
        String this$filePath = this.getFilePath();
        String other$filePath = other.getFilePath();
        if (this$filePath == null ? other$filePath != null : !this$filePath.equals(other$filePath)) {
            return false;
        }
        String this$fileNameReg = this.getFileNameReg();
        String other$fileNameReg = other.getFileNameReg();
        if (this$fileNameReg == null ? other$fileNameReg != null : !this$fileNameReg.equals(other$fileNameReg)) {
            return false;
        }
        OutputDir this$outputDir = this.outputDir;
        OutputDir other$outputDir = other.outputDir;
        if (this$outputDir == null ? other$outputDir != null : !((Object)((Object)this$outputDir)).equals((Object)other$outputDir)) {
            return false;
        }
        return this.isPartition() == other.isPartition();
    }

    protected boolean canEqual(Object other) {
        return other instanceof BaseTemplate;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $template = this.getTemplate();
        result = result * 59 + ($template == null ? 43 : $template.hashCode());
        String $filePath = this.getFilePath();
        result = result * 59 + ($filePath == null ? 43 : $filePath.hashCode());
        String $fileNameReg = this.getFileNameReg();
        result = result * 59 + ($fileNameReg == null ? 43 : $fileNameReg.hashCode());
        OutputDir $outputDir = this.outputDir;
        result = result * 59 + ($outputDir == null ? 43 : ((Object)((Object)$outputDir)).hashCode());
        result = result * 59 + (this.isPartition() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "BaseTemplate(template=" + this.getTemplate() + ", filePath=" + this.getFilePath() + ", fileNameReg=" + this.getFileNameReg() + ", outputDir=" + (Object)((Object)this.outputDir) + ", isPartition=" + this.isPartition() + ")";
    }

    public BaseTemplate setPartition(boolean isPartition) {
        this.isPartition = isPartition;
        return this;
    }

    static {
        VAR_MAPPING.put("${entity}", "entity.name");
        VAR_MAPPING.put("${query}", "entityQuery.name");
        VAR_MAPPING.put("${update}", "entityUpdate.name");
    }
}

