/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.generator.template.impl;

import cn.org.atool.fluent.mybatis.base.IEntity;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.test4j.generator.config.impl.TableField;
import org.test4j.generator.config.impl.TableSetter;
import org.test4j.generator.template.BaseTemplate;
import org.test4j.tools.commons.StringHelper;
import org.test4j.tools.commons.TextBuilder;

public class EntityTemplate
extends BaseTemplate {
    private static Set<String> Allow_Entity_Bounds = new HashSet<String>();

    public EntityTemplate() {
        super("templates/Entity.java.vm", "entity/*Entity.java");
    }

    @Override
    public String getTemplateId() {
        return "entity";
    }

    @Override
    protected void templateConfigs(TableSetter table, Map<String, Object> parent, Map<String, Object> ctx) {
        this.putInterfaces(parent, ctx, table.getEntityInterfaces());
        ctx.put("primaryKey", this.findPrimaryKey(table));
        HashMap<String, String> annotation = new HashMap<String, String>();
        for (TableField field : table.getFields()) {
            String text = this.fieldAnnotation(table, field);
            annotation.put(field.getName(), text);
        }
        ctx.put("annotation", annotation);
        StringBuffer buff = new StringBuffer();
        buff.append("table = ").append('\"').append(table.getTableName()).append('\"');
        if (StringHelper.isNotBlank((String)table.getMapperBeanPrefix())) {
            buff.append(", mapperBeanPrefix = ").append('\"').append(table.getMapperBeanPrefix()).append('\"');
        }
        if (table.getBaseDaoInterfaces() != null && !table.getBaseDaoInterfaces().isEmpty()) {
            String daos = table.getBaseDaoInterfaces().stream().map(dao -> dao.getSimpleName() + ".class").collect(Collectors.joining(", ", "{", "}"));
            buff.append(",\n\tdaoInterface = ").append(daos);
            for (Class dao2 : table.getBaseDaoInterfaces()) {
                this.addImport(parent, dao2);
            }
        }
        ctx.put("fluentMybatis", buff.toString());
    }

    private void addImport(Map<String, Object> parent, Class klass) {
        parent.put("importTypes", parent.get("importTypes") + "\nimport " + klass.getName() + ";");
    }

    private String findPrimaryKey(TableSetter table) {
        for (TableField field : table.getFields()) {
            if (!field.isPrimary()) continue;
            return field.getName();
        }
        return "null";
    }

    private void putInterfaces(Map<String, Object> parent, Map<String, Object> ctx, List<Class> interfaces) {
        if (interfaces == null || interfaces.size() == 0) {
            return;
        }
        ctx.put("interface", interfaces.stream().map(i -> "import " + i.getName() + ";").collect(Collectors.joining("\n")));
        ctx.put("interfaceName", interfaces.stream().map(clazz -> {
            String name = clazz.getSimpleName();
            if (clazz.getTypeParameters().length != 1) {
                return name;
            }
            boolean useEntityType = false;
            for (Type bound : clazz.getTypeParameters()[0].getBounds()) {
                String tn = bound.getTypeName();
                if (!Objects.equals(tn, name) && !Allow_Entity_Bounds.contains(tn)) continue;
                useEntityType = true;
                break;
            }
            if (useEntityType) {
                name = name + "<" + BaseTemplate.getConfig(parent, "entity.name", null) + ">";
            }
            return name;
        }).collect(Collectors.joining(", ", ", ", "")));
    }

    private String fieldAnnotation(TableSetter table, TableField field) {
        TextBuilder text = TextBuilder.build();
        if (field.isPrimary()) {
            text.quotas("@TableId(value = '%s'", new Object[]{field.getColumnName()});
            if (!field.isPrimaryId()) {
                text.append(", auto = false", new Object[0]);
            }
            if (!StringHelper.isBlank((String)table.getSeqName())) {
                text.quotas(", seqName='%s'", new Object[]{table.getSeqName()});
            }
            text.append(")", new Object[0]);
        } else {
            text.quotas("@TableField(value = '%s'", new Object[]{field.getColumnName()});
            if (StringHelper.isNotBlank((String)field.getInsert())) {
                text.quotas(", insert = '%s'", new Object[]{field.getInsert()});
            }
            if (StringHelper.isNotBlank((String)field.getUpdate())) {
                text.quotas(", update = '%s'", new Object[]{field.getUpdate()});
            }
            if (field.getIsLarge() != null && !field.getIsLarge().booleanValue()) {
                text.quotas(", notLarge = false", new Object[0]);
            }
            if (field.getTypeHandler() != null) {
                text.quotas(", typeHandler = %s.class", new Object[]{field.getTypeHandler().getName()});
            }
            text.append(")", new Object[0]);
        }
        return text.toString();
    }

    @Override
    protected String getPackage(TableSetter table) {
        String pack = super.getPackage(table);
        return pack.endsWith(".") ? pack.substring(0, pack.length() - 1) : pack;
    }

    static {
        Allow_Entity_Bounds.add(IEntity.class.getName());
        Allow_Entity_Bounds.add(Object.class.getName());
        Allow_Entity_Bounds.add(Serializable.class.getName());
    }
}

