/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.junit;

import java.util.Map;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.test4j.junit.Test4J;
import org.test4j.junit.annotations.DataFrom;
import org.test4j.module.core.ICoreInitial;
import org.test4j.module.core.TestContext;
import org.test4j.spec.ISpec;
import org.test4j.spec.ISpecExecutorFactory;
import org.test4j.spec.SharedData;
import org.test4j.spec.Steps;
import org.test4j.spec.inner.IScenario;
import org.test4j.spec.inner.ISpecMethod;
import org.test4j.spec.inner.ISpecPrinter;
import org.test4j.tools.datagen.DataProviderIterator;

public abstract class JSpec
extends Test4J
implements ISpec {
    static ISpecExecutorFactory specFactory = ICoreInitial.initSpecExecutorFactory();
    private final Map<ISpecMethod.SpecMethodID, ISpecMethod> specMethods = specFactory.findMethodsInSpec(this.getClass());
    private Map<String, Steps> stepsInstances;
    private static ThreadLocal<ISpecPrinter> threadPrinter = new ThreadLocal();
    protected SharedData shared;

    protected void initSharedData() {
    }

    public final SharedData getSharedData() {
        if (this.shared == null) {
            this.shared = new SharedData.EmptyData();
        }
        return this.shared;
    }

    public final Steps getStepsInstance(String stepClazzName) {
        return this.stepsInstances.get(stepClazzName);
    }

    @BeforeClass
    public static void initSpecPrinter() {
        threadPrinter.set(specFactory.newSpecPrinter());
    }

    @AfterClass
    public static void cleanSpecPrinter() {
        JSpec.getPrinter().printSummary(TestContext.currTestedClazz());
        threadPrinter.remove();
    }

    static ISpecPrinter getPrinter() {
        ISpecPrinter printer = threadPrinter.get();
        if (printer == null) {
            printer = specFactory.newSpecPrinter();
            threadPrinter.set(printer);
        }
        return printer;
    }

    @Test
    @DataFrom(value="scenariosOfStorySpec")
    public void runScenario(IScenario scenario) throws Throwable {
        this.initSharedData();
        this.stepsInstances = specFactory.newSteps((ISpec)this);
        specFactory.runScenario((ISpec)this, scenario, this.specMethods, JSpec.getPrinter());
    }

    final DataProviderIterator<IScenario> scenariosOfStorySpec() {
        DataProviderIterator it = specFactory.findScenario(this.getClass());
        return it;
    }
}

