/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.junit;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;
import org.test4j.junit.annotations.DataFrom;
import org.test4j.junit.parametermethod.FrameworkMethodWithParameters;
import org.test4j.junit.parametermethod.ParameterDataFromHelper;
import org.test4j.junit.statement.MethodAroundStatement;
import org.test4j.junit.statement.TestAroundStatement;
import org.test4j.module.core.ClazzAroundObject;
import org.test4j.module.core.CoreModule;
import org.test4j.module.core.TestContext;
import org.test4j.module.core.TestListener;
import org.test4j.tools.commons.MethodHelper;

public class Test4JRunner
extends BlockJUnit4ClassRunner {
    private Object testedObject = null;
    private final Class testClazz;
    private RuntimeException error;
    private List<FrameworkMethod> testMethods;

    public Test4JRunner(Class testClass) throws InitializationError {
        super(testClass);
        this.testClazz = testClass;
        TestContext.setContext((Object)new ClazzAroundObject.ClazzBeforeObject(this.testClazz), null);
    }

    protected Object createTest() throws Exception {
        if (this.testedObject == null) {
            this.testedObject = this.getTestedObject();
        }
        return this.testedObject;
    }

    private Object getTestedObject() throws Exception {
        this.error = null;
        try {
            Object tested = super.createTest();
            return tested;
        }
        catch (Error e) {
            this.error = new RuntimeException(e);
            throw e;
        }
        catch (Exception e) {
            this.error = new RuntimeException(e);
            throw e;
        }
    }

    private void initTestedObject() {
        try {
            this.testedObject = super.createTest();
            TestContext.setContext((Object)this.testedObject, null);
        }
        catch (Throwable e) {
            this.error = new RuntimeException(e);
        }
    }

    protected Statement childrenInvoker(final RunNotifier notifier) {
        return new Statement(){

            public void evaluate() {
                Test4JRunner.this.initTestedObject();
                Test4JRunner.this.getTestListener().beforeClass(Test4JRunner.this.testClazz);
                MethodHelper.invokeUnThrow((Object)((Object)Test4JRunner.this), (String)"runChildren", (Object[])new Object[]{notifier});
                Test4JRunner.this.getTestListener().afterClass(Test4JRunner.this.testedObject);
            }
        };
    }

    protected Statement methodBlock(FrameworkMethod method) {
        Statement statement = super.methodBlock(method);
        if (this.error != null) {
            throw this.error;
        }
        statement = new TestAroundStatement(statement, this.getTestListener(), this.testedObject, method.getMethod());
        return statement;
    }

    public Statement methodInvoker(FrameworkMethod method, Object test) {
        Statement statement = super.methodInvoker(method, test);
        statement = new MethodAroundStatement(statement, this.getTestListener(), test, method.getMethod());
        return statement;
    }

    protected String testName(FrameworkMethod method) {
        if (method instanceof FrameworkMethodWithParameters) {
            return method.toString();
        }
        return super.testName(method);
    }

    protected List<FrameworkMethod> computeTestMethods() {
        Class testclazz = this.getTestClass().getJavaClass();
        if (this.testMethods == null) {
            List initTestMethods = super.computeTestMethods();
            this.testMethods = new ArrayList<FrameworkMethod>();
            for (FrameworkMethod frameworkMethod : initTestMethods) {
                Method testMethod = frameworkMethod.getMethod();
                testMethod.getDeclaringClass();
                DataFrom dataFrom = testMethod.getAnnotation(DataFrom.class);
                if (dataFrom == null) {
                    this.testMethods.add(frameworkMethod);
                    continue;
                }
                List<FrameworkMethodWithParameters> parameterizedTestMethods = ParameterDataFromHelper.computeParameterizedTestMethods(testclazz, frameworkMethod.getMethod(), dataFrom);
                this.testMethods.addAll(parameterizedTestMethods);
            }
        }
        return this.testMethods;
    }

    protected TestListener getTestListener() {
        return CoreModule.getTestListener();
    }

    static {
        CoreModule.initSingletonInstance();
    }
}

