/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.junit.filter.acceptor;

import java.lang.reflect.Method;
import java.util.List;
import junit.framework.TestCase;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Suite;
import org.test4j.junit.filter.SuiteType;
import org.test4j.junit.filter.acceptor.TestAcceptor;
import org.test4j.junit.filter.finder.FilterCondiction;
import org.test4j.tools.commons.AnnotationHelper;
import org.test4j.tools.commons.ClazzHelper;

public class TestInClasspathAcceptor
implements TestAcceptor {
    private final FilterCondiction testerFilter;

    public TestInClasspathAcceptor(FilterCondiction testerFilter) {
        this.testerFilter = testerFilter;
    }

    @Override
    public boolean isCorrectTestType(Class<?> clazz) {
        List<SuiteType> types = this.testerFilter.getSuiteTypes();
        if (types.contains((Object)SuiteType.JUNT4_TEST_CLASSES) && this.isJunit4TestClaz(clazz)) {
            return true;
        }
        if (types.contains((Object)SuiteType.JUNIT38_TEST_CLASSES) && this.isJUnit38TestClaz(clazz)) {
            return true;
        }
        if (types.contains((Object)SuiteType.SUITE_TEST_CLASSES)) {
            return this.isJunit4SuiteClaz(clazz);
        }
        return false;
    }

    private boolean isJUnit38TestClaz(Class<?> clazz) {
        return TestCase.class.isAssignableFrom(clazz);
    }

    private boolean isJunit4TestClaz(Class<?> clazz) {
        try {
            for (Method method : clazz.getMethods()) {
                if (method.getAnnotation(Test.class) == null) continue;
                return true;
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        return false;
    }

    private boolean isJunit4SuiteClaz(Class<?> clazz) {
        RunWith runwith = (RunWith)AnnotationHelper.getClassLevelAnnotation(RunWith.class, clazz);
        if (runwith == null) {
            return false;
        }
        return Suite.class.isAssignableFrom(runwith.value());
    }

    @Override
    public boolean isCorrectClazType(Class<?> clazz) {
        if (clazz == null || ClazzHelper.isAbstract(clazz) || clazz.isAnonymousClass() || clazz.isInterface() || clazz.isLocalClass() || clazz.isEnum() || clazz.isMemberClass() || clazz.isAnnotation()) {
            return false;
        }
        boolean isAcceptedByExcluded = this.acceptedByBaseTypes(clazz, this.testerFilter.getExcludedBaseTypes(), false);
        if (isAcceptedByExcluded) {
            return false;
        }
        boolean isAcceptedByIncluded = this.acceptedByBaseTypes(clazz, this.testerFilter.getIncludedBaseTypes(), true);
        return isAcceptedByIncluded;
    }

    private boolean acceptedByBaseTypes(Class<?> clazz, Class<?>[] bases, boolean _default) {
        if (bases == null || bases.length == 0) {
            return _default;
        }
        for (Class<?> base : bases) {
            if (!base.isAssignableFrom(clazz)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isAcceptedByPatterns(String className) {
        boolean isNegationAccepted = this.acceptedByPatterns(className, this.testerFilter.getNegationFilters(), false);
        if (isNegationAccepted) {
            return false;
        }
        boolean isPositionAccepted = this.acceptedByPatterns(className, this.testerFilter.getPositiveFilters(), true);
        return isPositionAccepted;
    }

    private boolean acceptedByPatterns(String className, List<String> patterns, boolean _default) {
        if (patterns == null || patterns.isEmpty()) {
            return _default;
        }
        for (String pattern : patterns) {
            if (!className.matches(pattern)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean acceptInnerClass() {
        return true;
    }

    @Override
    public boolean searchInJars() {
        return this.testerFilter.isSearchInJars();
    }
}

