/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.junit.filter.finder;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.test4j.junit.filter.acceptor.TestAcceptor;
import org.test4j.junit.filter.finder.TestClazFinder;
import org.test4j.junit.filter.iterator.DirFileIterator;
import org.test4j.junit.filter.iterator.JarFileIterator;
import org.test4j.junit.filter.iterator.NonFileIterator;
import org.test4j.tools.commons.ClazzHelper;
import org.test4j.tools.commons.ResourceHelper;

public class ClasspathTestClazFinder
implements TestClazFinder {
    private static final int CLASS_SUFFIX_LENGTH = ".class".length();
    private final TestAcceptor tester;
    private final String classpathProperty;

    public ClasspathTestClazFinder(TestAcceptor tester, String classpathProperty) {
        this.tester = tester;
        this.classpathProperty = classpathProperty;
    }

    @Override
    public List<Class<?>> find() {
        String classpath = this.getClasspath();
        List<String> paths = this.splitClassPath(classpath);
        return this.findClassesInRoots(paths);
    }

    private String getClasspath() {
        String classPath = System.getProperty(this.classpathProperty);
        if (classPath == null) {
            classPath = System.getProperty("java.class.path");
        }
        return classPath;
    }

    private List<String> splitClassPath(String classPath) {
        String separator = System.getProperty("path.separator");
        return Arrays.asList(classPath.split(separator));
    }

    private List<Class<?>> findClassesInRoots(List<String> roots) {
        ArrayList classes = new ArrayList(100);
        for (String root : roots) {
            this.gatherClassesInRoot(new File(root), classes);
        }
        return classes;
    }

    private void gatherClassesInRoot(File classpathRoot, List<Class<?>> classes) {
        Iterable relativeFilenames = new NonFileIterator();
        if (this.tester.searchInJars() && ResourceHelper.isJarFile((File)classpathRoot)) {
            try {
                relativeFilenames = new JarFileIterator(classpathRoot);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else if (classpathRoot.isDirectory()) {
            relativeFilenames = new DirFileIterator(classpathRoot);
        }
        for (String fileName : relativeFilenames) {
            this.addTestClazzIfAccepted(classes, fileName);
        }
    }

    private void addTestClazzIfAccepted(List<Class<?>> classes, String fileName) {
        if (!ClazzHelper.isClassFile((String)fileName)) {
            return;
        }
        String clazzPath = fileName.substring(0, fileName.length() - CLASS_SUFFIX_LENGTH);
        String clazzName = ClazzHelper.replaceFileSeparators((String)clazzPath);
        if (!this.tester.isAcceptedByPatterns(clazzName)) {
            return;
        }
        if (!this.tester.acceptInnerClass() && ClazzHelper.isInnerClass((String)clazzName)) {
            return;
        }
        try {
            Class<?> clazz = Class.forName(clazzName);
            boolean isAcceptedByBaseType = this.tester.isCorrectClazType(clazz);
            if (!isAcceptedByBaseType) {
                return;
            }
            if (this.tester.isCorrectTestType(clazz)) {
                classes.add(clazz);
            }
        }
        catch (ClassNotFoundException cnfe) {
        }
        catch (NoClassDefFoundError ncdfe) {
        }
        catch (ExceptionInInitializerError ciie) {
        }
        catch (UnsatisfiedLinkError ule) {
            // empty catch block
        }
    }

    public TestAcceptor getTester() {
        return this.tester;
    }
}

