/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.junit.filter.finder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.test4j.junit.annotations.AnnotationDefaultValue;
import org.test4j.junit.annotations.ClazFinder;
import org.test4j.junit.filter.SuiteType;
import org.test4j.tools.commons.StringHelper;

public class FilterCondiction {
    private List<SuiteType> suiteTypes;
    private boolean searchInJars;
    private List<String> positiveFilters;
    private List<String> negationFilters;
    private Class<?>[] includedBaseTypes;
    private Class<?>[] excludedBaseTypes;

    public FilterCondiction() {
        this.searchInJars = false;
        this.suiteTypes = Arrays.asList(AnnotationDefaultValue.DEFAULT_SUITE_TYPES);
        this.includedBaseTypes = AnnotationDefaultValue.DEFAULT_INCLUDED_BASE_TYPES;
        this.excludedBaseTypes = AnnotationDefaultValue.DEFAULT_EXCLUDED_BASES_TYPES;
        this.setFilterPatterns(AnnotationDefaultValue.DEFAULT_CLASSNAME_FILTERS);
    }

    public FilterCondiction(boolean searchInJar, String[] patterns, SuiteType[] suiteTypes, Class<?>[] baseTypes, Class<?>[] excludedBaseTypes) {
        this.searchInJars = searchInJar;
        this.suiteTypes = Arrays.asList(suiteTypes);
        this.includedBaseTypes = baseTypes;
        this.excludedBaseTypes = excludedBaseTypes;
        this.setFilterPatterns(patterns);
    }

    public boolean isSearchInJars() {
        return this.searchInJars;
    }

    public List<SuiteType> getSuiteTypes() {
        return this.suiteTypes;
    }

    public List<String> getPositiveFilters() {
        return this.positiveFilters;
    }

    public List<String> getNegationFilters() {
        return this.negationFilters;
    }

    public Class<?>[] getIncludedBaseTypes() {
        return this.includedBaseTypes;
    }

    public Class<?>[] getExcludedBaseTypes() {
        return this.excludedBaseTypes;
    }

    private void setFilterPatterns(String[] filterPatterns) {
        this.positiveFilters = new ArrayList<String>();
        this.negationFilters = new ArrayList<String>();
        if (filterPatterns == null) {
            return;
        }
        for (String pattern : filterPatterns) {
            String regex;
            String _pattern = StringHelper.trim((String)pattern);
            if (StringHelper.isBlankOrNull((String)_pattern)) continue;
            if (_pattern.startsWith("!")) {
                if (StringHelper.isBlankOrNull((String)(_pattern = _pattern.substring(1).trim()))) continue;
                regex = this.convertToRegular(_pattern);
                this.negationFilters.add(regex);
                continue;
            }
            regex = this.convertToRegular(_pattern);
            this.positiveFilters.add(regex);
        }
    }

    private String convertToRegular(String input) {
        if (StringHelper.isBlankOrNull((String)input)) {
            return ".*";
        }
        String regex = input.replaceAll("\\.", "\\\\.").replaceAll("\\*", ".*");
        return regex;
    }

    public void initFilters(ClazFinder testFilterAnnotation) {
        if (testFilterAnnotation == null) {
            return;
        }
        this.searchInJars = testFilterAnnotation.inJars();
        this.suiteTypes = Arrays.asList(testFilterAnnotation.value());
        this.includedBaseTypes = testFilterAnnotation.baseType().includes();
        this.excludedBaseTypes = testFilterAnnotation.baseType().excludes();
        String[] patterns = testFilterAnnotation.patterns();
        this.setFilterPatterns(patterns);
    }
}

