/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.junit.filter.iterator;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class DirFileIterator
implements Iterator<String>,
Iterable<String> {
    private List<String> allClazFiles = new ArrayList<String>();
    private int index = 0;

    public DirFileIterator(File root) {
        int prefixLength = root.getAbsolutePath().length() + 1;
        if (root.isFile()) {
            throw new RuntimeException("the root dir can't be a file.");
        }
        DirFileIterator.recursivedSearch(this.allClazFiles, root, prefixLength);
    }

    private static void recursivedSearch(List<String> allClazFiles, File dir, int prefixLength) {
        File[] files = dir.listFiles();
        if (files == null) {
            return;
        }
        for (File subFile : files) {
            if (subFile.isFile()) {
                String fileName = subFile.getAbsolutePath();
                if (!fileName.endsWith(".class")) continue;
                allClazFiles.add(fileName.substring(prefixLength));
                continue;
            }
            DirFileIterator.recursivedSearch(allClazFiles, subFile, prefixLength);
        }
    }

    @Override
    public boolean hasNext() {
        return this.index < this.allClazFiles.size();
    }

    @Override
    public String next() {
        if (this.hasNext()) {
            String next = this.allClazFiles.get(this.index);
            ++this.index;
            return next;
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public Iterator<String> iterator() {
        return this;
    }
}

