/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.junit.filter.iterator;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class JarFileIterator
implements Iterator<String>,
Iterable<String> {
    private Enumeration<JarEntry> entries;
    private JarEntry next;

    public JarFileIterator(File jarFile) throws IOException {
        JarFile jar = new JarFile(jarFile);
        this.entries = jar.entries();
        this.retrieveNextElement();
    }

    private void retrieveNextElement() {
        this.next = null;
        while (this.entries.hasMoreElements()) {
            this.next = this.entries.nextElement();
            if (this.next.isDirectory()) continue;
            break;
        }
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public String next() {
        if (this.next == null) {
            throw new NoSuchElementException();
        }
        String value = this.next.getName();
        this.retrieveNextElement();
        return value;
    }

    @Override
    public void remove() {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public Iterator<String> iterator() {
        return this;
    }
}

