/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.junit.parametermethod;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.test4j.junit.annotations.DataFrom;
import org.test4j.junit.parametermethod.FrameworkMethodWithParameters;
import org.test4j.tools.commons.MethodHelper;
import org.test4j.tools.commons.Reflector;
import org.test4j.tools.exception.NewInstanceException;
import org.test4j.tools.exception.NoSuchMethodRuntimeException;

public class ParameterDataFromHelper {
    public static List<FrameworkMethodWithParameters> computeParameterizedTestMethods(Class testClazz, Method testMethod, DataFrom dataFrom) {
        String fromMethod = dataFrom.value();
        if ("".equals(fromMethod)) {
            throw new RuntimeException("You should specify the value property of @DataFrom() item.");
        }
        switch (dataFrom.source()) {
            case FromMethod: {
                Class<?> dataFromClaz = dataFrom.clazz();
                if (dataFromClaz == DataFrom.class) {
                    dataFromClaz = testMethod.getDeclaringClass();
                }
                return ParameterDataFromHelper.computeParameterziedFromDataProviderMethod(testClazz, testMethod, fromMethod, dataFromClaz);
            }
        }
        throw new RuntimeException("umimplement the data from uri mode.");
    }

    private static List<FrameworkMethodWithParameters> computeParameterziedFromDataProviderMethod(Class testClazz, Method testMethod, String dataFromMethod, Class dataFromClaz) {
        Object data = ParameterDataFromHelper.getDataFromMethod(dataFromMethod, testClazz, dataFromClaz);
        if (data instanceof Iterator) {
            return ParameterDataFromHelper.computeParameterFromIterator(testMethod, (Iterator)data);
        }
        if (data instanceof Object[][]) {
            return ParameterDataFromHelper.computeParameterFromArray(testMethod, (Object[][])data);
        }
        throw new RuntimeException("The @DataFrom method can only return value of type Iterator<Object[]> or Object[][].");
    }

    private static Object getDataFromMethod(String dataFromMethod, Class testClazz, Class dataFromClaz) {
        try {
            if (dataFromClaz.isAssignableFrom(testClazz)) {
                Object from = Reflector.instance.newInstance(testClazz);
                Object data = MethodHelper.invokeUnThrow((Object)from, (String)dataFromMethod, (Object[])new Object[0]);
                return data;
            }
            Object from = Reflector.instance.newInstance(dataFromClaz);
            Object data = MethodHelper.invokeUnThrow((Object)from, (String)dataFromMethod, (Object[])new Object[0]);
            return data;
        }
        catch (NewInstanceException e1) {
            try {
                Object data = MethodHelper.invokeStatic((Class)dataFromClaz, (String)dataFromMethod, (Object[])new Object[0]);
                return data;
            }
            catch (NoSuchMethodRuntimeException e2) {
                throw new RuntimeException("The @DataFrom method isn't a static method or isn't declared in a concrete class.", e2);
            }
        }
    }

    private static List<FrameworkMethodWithParameters> computeParameterFromIterator(Method method, Iterator iterator) {
        ArrayList<FrameworkMethodWithParameters> methodWithParameters = new ArrayList<FrameworkMethodWithParameters>();
        while (iterator.hasNext()) {
            Object caseData = iterator.next();
            if (caseData instanceof Object[]) {
                methodWithParameters.add(new FrameworkMethodWithParameters(method, (Object[])caseData));
                continue;
            }
            methodWithParameters.add(new FrameworkMethodWithParameters(method, new Object[]{caseData}));
        }
        return methodWithParameters;
    }

    private static List<FrameworkMethodWithParameters> computeParameterFromArray(Method method, Object[][] array) {
        ArrayList<FrameworkMethodWithParameters> methodWithParameters = new ArrayList<FrameworkMethodWithParameters>();
        for (Object[] caseData : array) {
            methodWithParameters.add(new FrameworkMethodWithParameters(method, caseData));
        }
        return methodWithParameters;
    }
}

