/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.junit.suite;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.Suite;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.RunnerBuilder;
import org.test4j.junit.annotations.BeforeSuite;
import org.test4j.junit.filter.ClasspathFilterFactory;
import org.test4j.junit.filter.FilterFactory;
import org.test4j.junit.filter.finder.TestClazFinder;
import org.test4j.tools.commons.MethodHelper;
import org.test4j.tools.reflector.MethodAccessor;

public class ClasspathSuite
extends Suite {
    private final Class<?> suiteClass;

    public ClasspathSuite(Class<?> suiteClass, RunnerBuilder builder) throws InitializationError {
        super(builder, suiteClass, (Class[])ClasspathSuite.getSortedTestclasses(suiteClass, new ClasspathFilterFactory()));
        this.suiteClass = suiteClass;
    }

    public ClasspathSuite(Class<?> suiteClass, RunnerBuilder builder, FilterFactory filterFactory) throws InitializationError {
        super(builder, suiteClass, (Class[])ClasspathSuite.getSortedTestclasses(suiteClass, filterFactory));
        this.suiteClass = suiteClass;
    }

    private static Class<?>[] getSortedTestclasses(Class<?> suiteClass, FilterFactory filterFactory) {
        TestClazFinder finder = filterFactory.createFinder(suiteClass);
        List<Class<?>> testclasses = finder.find();
        Collections.sort(testclasses, new Comparator<Class<?>>(){

            @Override
            public int compare(Class<?> o1, Class<?> o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        return testclasses.toArray(new Class[testclasses.size()]);
    }

    public void run(RunNotifier notifier) {
        try {
            this.runBeforeMethods();
        }
        catch (Exception e) {
            notifier.fireTestFailure(new Failure(this.getDescription(), (Throwable)e));
            return;
        }
        super.run(notifier);
    }

    private void runBeforeMethods() throws Exception {
        for (Method each : this.suiteClass.getMethods()) {
            boolean isPublicStaticVoid;
            boolean isBeforeSuiteMethod = each.isAnnotationPresent(BeforeSuite.class);
            if (!isBeforeSuiteMethod || !(isPublicStaticVoid = MethodHelper.isPublicStaticVoid((Method)each))) continue;
            try {
                new MethodAccessor(each).invokeStatic((Object[])new String[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw e;
            }
        }
    }
}

