/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.junit.suite;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.junit.experimental.categories.Category;
import org.junit.runner.Description;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.manipulation.NoTestsRemainException;
import org.junit.runners.Suite;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.RunnerBuilder;
import org.test4j.junit.annotations.AnnotationDefaultValue;
import org.test4j.junit.annotations.Group;
import org.test4j.junit.annotations.RunGroup;
import org.test4j.tools.commons.StringHelper;

public class Groups
extends Suite {
    public Groups(Class<?> klass, RunnerBuilder builder) throws InitializationError {
        super(klass, builder);
        try {
            RunGroup annotation = klass.getAnnotation(RunGroup.class);
            String[] includedGroups = annotation == null ? AnnotationDefaultValue.DEFAULT_GROUP_VALUE : annotation.includes();
            String[] excludedGroups = annotation == null ? AnnotationDefaultValue.DEFAULT_GROUP_VALUE : annotation.excludes();
            GroupFilter filter = new GroupFilter(includedGroups, excludedGroups);
            this.filter(filter);
        }
        catch (NoTestsRemainException e) {
            throw new InitializationError((Throwable)e);
        }
        this.assertNoCategorizedDescendentsOfUncategorizeableParents(this.getDescription());
    }

    private void assertNoCategorizedDescendentsOfUncategorizeableParents(Description description) throws InitializationError {
        if (!Groups.canHaveCategorizedChildren(description)) {
            this.assertNoDescendantsHaveCategoryAnnotations(description);
        }
        for (Description each : description.getChildren()) {
            this.assertNoCategorizedDescendentsOfUncategorizeableParents(each);
        }
    }

    private void assertNoDescendantsHaveCategoryAnnotations(Description description) throws InitializationError {
        for (Description each : description.getChildren()) {
            if (each.getAnnotation(Category.class) != null) {
                throw new InitializationError("Category annotations on Parameterized classes are not supported on individual methods.");
            }
            this.assertNoDescendantsHaveCategoryAnnotations(each);
        }
    }

    private static boolean canHaveCategorizedChildren(Description description) {
        for (Description each : description.getChildren()) {
            if (each.getTestClass() != null) continue;
            return false;
        }
        return true;
    }

    public static class GroupFilter
    extends Filter {
        private final List<String> gIncluded;
        private final List<String> gExcluded;

        public static GroupFilter include(String[] includedGroups) {
            return new GroupFilter(includedGroups, AnnotationDefaultValue.DEFAULT_GROUP_VALUE);
        }

        public GroupFilter(String[] includedGroups, String[] excludedGroups) {
            this.gIncluded = Arrays.asList(includedGroups);
            this.gExcluded = Arrays.asList(excludedGroups);
        }

        public String describe() {
            return "groups " + StringHelper.merger(this.gIncluded, (char)',');
        }

        public boolean shouldRun(Description description) {
            if (this.hasCorrectGroupAnnotation(description)) {
                return true;
            }
            for (Description each : description.getChildren()) {
                if (!this.shouldRun(each)) continue;
                return true;
            }
            return false;
        }

        private boolean hasCorrectGroupAnnotation(Description description) {
            Set<String> groups = this.groups(description);
            if (groups.isEmpty()) {
                return this.gIncluded.size() == 0;
            }
            for (String group : groups) {
                if (!this.gExcluded.contains(group)) continue;
                return false;
            }
            if (this.gIncluded.size() == 0) {
                return true;
            }
            for (String group : groups) {
                if (!this.gIncluded.contains(group)) continue;
                return true;
            }
            return false;
        }

        private Set<String> groups(Description description) {
            HashSet<String> groups = new HashSet<String>();
            String[] directGroups = this.directGroup(description);
            groups.addAll(Arrays.asList(directGroups));
            String[] parentGroups = this.directGroup(this.parentDescription(description));
            groups.addAll(Arrays.asList(parentGroups));
            return groups;
        }

        private Description parentDescription(Description description) {
            Class testClass = description.getTestClass();
            if (testClass == null) {
                return null;
            }
            Description parentDescription = Description.createSuiteDescription((Class)testClass);
            return parentDescription;
        }

        private String[] directGroup(Description description) {
            if (description == null) {
                return AnnotationDefaultValue.DEFAULT_GROUP_VALUE;
            }
            Group annotation = (Group)description.getAnnotation(Group.class);
            if (annotation == null) {
                return AnnotationDefaultValue.DEFAULT_GROUP_VALUE;
            }
            return annotation.value();
        }
    }
}

