/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.activemq;

import java.time.Duration;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.utility.DockerImageName;

public class ActiveMQContainer
extends GenericContainer<ActiveMQContainer> {
    private static final DockerImageName DEFAULT_IMAGE = DockerImageName.parse((String)"apache/activemq-classic");
    private static final int WEB_CONSOLE_PORT = 8161;
    private static final int TCP_PORT = 61616;
    private static final int AMQP_PORT = 5672;
    private static final int STOMP_PORT = 61613;
    private static final int MQTT_PORT = 1883;
    private static final int WS_PORT = 61614;
    private String username;
    private String password;

    public ActiveMQContainer(String image) {
        this(DockerImageName.parse((String)image));
    }

    public ActiveMQContainer(DockerImageName dockerImageName) {
        super(dockerImageName);
        dockerImageName.assertCompatibleWith(new DockerImageName[]{DEFAULT_IMAGE});
        this.withExposedPorts(new Integer[]{8161, 61616, 5672, 61613, 1883, 61614});
        this.waitingFor(Wait.forLogMessage((String)".*Apache ActiveMQ.*started.*", (int)1).withStartupTimeout(Duration.ofMinutes(1L)));
    }

    protected void configure() {
        if (this.username != null) {
            this.addEnv("ACTIVEMQ_CONNECTION_USER", this.username);
        }
        if (this.password != null) {
            this.addEnv("ACTIVEMQ_CONNECTION_PASSWORD", this.password);
        }
    }

    public ActiveMQContainer withUser(String username) {
        this.username = username;
        return this;
    }

    public ActiveMQContainer withPassword(String password) {
        this.password = password;
        return this;
    }

    public String getBrokerUrl() {
        return String.format("tcp://%s:%s", this.getHost(), this.getMappedPort(61616));
    }

    public String getUser() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }
}

