/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.shaded.okio;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileSystemException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import org.codehaus.mojo.animal_sniffer.IgnoreJRERequirement;
import org.testcontainers.shaded.kotlin.Metadata;
import org.testcontainers.shaded.kotlin.jvm.internal.Intrinsics;
import org.testcontainers.shaded.okio.FileMetadata;
import org.testcontainers.shaded.okio.JvmSystemFileSystem;
import org.testcontainers.shaded.okio.Path;
import org.testcontainers.shaded.org.jetbrains.annotations.NotNull;
import org.testcontainers.shaded.org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0016J\u0018\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0016J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\u0006H\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\u0013\u0010\u000e\u001a\u0004\u0018\u00010\u000f*\u00020\u0010H\u0002\u00a2\u0006\u0002\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lorg/testcontainers/shaded/okio/NioSystemFileSystem;", "Lorg/testcontainers/shaded/okio/JvmSystemFileSystem;", "()V", "atomicMove", "", "source", "Lorg/testcontainers/shaded/okio/Path;", "target", "createSymlink", "metadataOrNull", "Lorg/testcontainers/shaded/okio/FileMetadata;", "path", "toString", "", "zeroToNull", "", "Ljava/nio/file/attribute/FileTime;", "(Ljava/nio/file/attribute/FileTime;)Ljava/lang/Long;", "org.testcontainers.shaded.okio"})
@IgnoreJRERequirement
public final class NioSystemFileSystem
extends JvmSystemFileSystem {
    @Override
    @Nullable
    public FileMetadata metadataOrNull(@NotNull Path path) {
        Object object;
        Intrinsics.checkNotNullParameter(path, "path");
        java.nio.file.Path nioPath = path.toNioPath();
        try {
            object = new LinkOption[]{LinkOption.NOFOLLOW_LINKS};
            object = Files.readAttributes(nioPath, BasicFileAttributes.class, (LinkOption[])object);
        }
        catch (NoSuchFileException _) {
            return null;
        }
        catch (FileSystemException _) {
            return null;
        }
        Object attributes = object;
        java.nio.file.Path symlinkTarget = attributes.isSymbolicLink() ? Files.readSymbolicLink(nioPath) : (java.nio.file.Path)null;
        java.nio.file.Path path2 = symlinkTarget;
        FileTime fileTime = attributes.creationTime();
        FileTime fileTime2 = attributes.lastModifiedTime();
        FileTime fileTime3 = attributes.lastAccessTime();
        return new FileMetadata(attributes.isRegularFile(), attributes.isDirectory(), path2 != null ? Path.Companion.get$default(Path.Companion, path2, false, 1, null) : null, attributes.size(), fileTime != null ? this.zeroToNull(fileTime) : null, fileTime2 != null ? this.zeroToNull(fileTime2) : null, fileTime3 != null ? this.zeroToNull(fileTime3) : null, null, 128, null);
    }

    private final Long zeroToNull(FileTime $this$zeroToNull) {
        Long l = $this$zeroToNull.toMillis();
        long it = ((Number)l).longValue();
        boolean bl = false;
        return it != 0L ? l : null;
    }

    @Override
    public void atomicMove(@NotNull Path source2, @NotNull Path target) {
        Intrinsics.checkNotNullParameter(source2, "source");
        Intrinsics.checkNotNullParameter(target, "target");
        try {
            CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING};
            Files.move(source2.toNioPath(), target.toNioPath(), copyOptionArray);
        }
        catch (NoSuchFileException e) {
            throw new FileNotFoundException(e.getMessage());
        }
        catch (UnsupportedOperationException e) {
            throw new IOException("atomic move not supported");
        }
    }

    @Override
    public void createSymlink(@NotNull Path source2, @NotNull Path target) {
        Intrinsics.checkNotNullParameter(source2, "source");
        Intrinsics.checkNotNullParameter(target, "target");
        Files.createSymbolicLink(source2.toNioPath(), target.toNioPath(), new FileAttribute[0]);
    }

    @Override
    @NotNull
    public String toString() {
        return "NioSystemFileSystem";
    }
}

