/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.azure;

import org.testcontainers.containers.GenericContainer;
import org.testcontainers.utility.DockerImageName;
import org.testcontainers.utility.MountableFile;

public class AzuriteContainer
extends GenericContainer<AzuriteContainer> {
    private static final String ALLOW_ALL_CONNECTIONS = "0.0.0.0";
    private static final int DEFAULT_BLOB_PORT = 10000;
    private static final int DEFAULT_QUEUE_PORT = 10001;
    private static final int DEFAULT_TABLE_PORT = 10002;
    private static final String CONNECTION_STRING_FORMAT = "DefaultEndpointsProtocol=%s;AccountName=%s;AccountKey=%s;BlobEndpoint=%s://%s:%d/%s;QueueEndpoint=%s://%s:%d/%s;TableEndpoint=%s://%s:%d/%s;";
    private static final String WELL_KNOWN_ACCOUNT_NAME = "devstoreaccount1";
    private static final String WELL_KNOWN_ACCOUNT_KEY = "Eby8vdM02xNOcqFlqUwJPLlmEtlCDXJ1OUzFT50uSRZ6IFsuFq2UVErCz4I6tq/K1SZFPTOtr/KBHBeksoGMGw==";
    private static final DockerImageName DEFAULT_IMAGE_NAME = DockerImageName.parse((String)"mcr.microsoft.com/azure-storage/azurite");
    private MountableFile cert = null;
    private String certExtension = null;
    private MountableFile key = null;
    private String pwd = null;

    public AzuriteContainer(String dockerImageName) {
        this(DockerImageName.parse((String)dockerImageName));
    }

    public AzuriteContainer(DockerImageName dockerImageName) {
        super(dockerImageName);
        dockerImageName.assertCompatibleWith(new DockerImageName[]{DEFAULT_IMAGE_NAME});
        this.withExposedPorts(new Integer[]{10000, 10001, 10002});
    }

    public AzuriteContainer withSsl(MountableFile pfxCert, String password) {
        this.cert = pfxCert;
        this.pwd = password;
        this.certExtension = ".pfx";
        return this;
    }

    public AzuriteContainer withSsl(MountableFile pemCert, MountableFile pemKey) {
        this.cert = pemCert;
        this.key = pemKey;
        this.certExtension = ".pem";
        return this;
    }

    protected void configure() {
        this.withCommand(this.getCommandLine());
        if (this.cert != null) {
            this.logger().info("Using path for cert file: '{}'", (Object)this.cert);
            this.withCopyFileToContainer(this.cert, "/cert" + this.certExtension);
            if (this.key != null) {
                this.logger().info("Using path for key file: '{}'", (Object)this.key);
                this.withCopyFileToContainer(this.key, "/key.pem");
            }
        }
    }

    public String getConnectionString() {
        return this.getConnectionString(WELL_KNOWN_ACCOUNT_NAME, WELL_KNOWN_ACCOUNT_KEY);
    }

    public String getConnectionString(String accountName, String accountKey) {
        String protocol = this.cert != null ? "https" : "http";
        return String.format(CONNECTION_STRING_FORMAT, protocol, accountName, accountKey, protocol, this.getHost(), this.getMappedPort(10000), accountName, protocol, this.getHost(), this.getMappedPort(10001), accountName, protocol, this.getHost(), this.getMappedPort(10002), accountName);
    }

    String getCommandLine() {
        StringBuilder args2 = new StringBuilder("azurite");
        args2.append(" --blobHost ").append(ALLOW_ALL_CONNECTIONS);
        args2.append(" --queueHost ").append(ALLOW_ALL_CONNECTIONS);
        args2.append(" --tableHost ").append(ALLOW_ALL_CONNECTIONS);
        if (this.cert != null) {
            args2.append(" --cert ").append("/cert").append(this.certExtension);
            if (this.pwd != null) {
                args2.append(" --pwd ").append(this.pwd);
            } else {
                args2.append(" --key ").append("/key.pem");
            }
        }
        String cmd = args2.toString();
        this.logger().debug("Using command line: '{}'", (Object)cmd);
        return cmd;
    }
}

