/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.couchbase;

import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.dockerjava.api.model.ContainerNetwork;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.rnorth.ducttape.unreliables.Unreliables;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.HttpWaitStrategy;
import org.testcontainers.containers.wait.strategy.WaitAllStrategy;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.containers.wait.strategy.WaitStrategyTarget;
import org.testcontainers.couchbase.BucketDefinition;
import org.testcontainers.couchbase.CouchbaseService;
import org.testcontainers.shaded.com.fasterxml.jackson.databind.JsonNode;
import org.testcontainers.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import org.testcontainers.shaded.okhttp3.Credentials;
import org.testcontainers.shaded.okhttp3.FormBody;
import org.testcontainers.shaded.okhttp3.OkHttpClient;
import org.testcontainers.shaded.okhttp3.Request;
import org.testcontainers.shaded.okhttp3.RequestBody;
import org.testcontainers.shaded.okhttp3.Response;

public class CouchbaseContainer
extends GenericContainer<CouchbaseContainer> {
    private static final int MGMT_PORT = 8091;
    private static final int MGMT_SSL_PORT = 18091;
    private static final int VIEW_PORT = 8092;
    private static final int VIEW_SSL_PORT = 18092;
    private static final int QUERY_PORT = 8093;
    private static final int QUERY_SSL_PORT = 18093;
    private static final int SEARCH_PORT = 8094;
    private static final int SEARCH_SSL_PORT = 18094;
    private static final int KV_PORT = 11210;
    private static final int KV_SSL_PORT = 11207;
    private static final String DOCKER_IMAGE_NAME = "couchbase/server";
    private static final String VERSION = "6.5.1";
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final OkHttpClient HTTP_CLIENT = new OkHttpClient();
    private String username = "Administrator";
    private String password = "password";
    private Set<CouchbaseService> enabledServices = EnumSet.allOf(CouchbaseService.class);
    private final List<BucketDefinition> buckets = new ArrayList<BucketDefinition>();

    public CouchbaseContainer() {
        this("couchbase/server:6.5.1");
    }

    public CouchbaseContainer(String imageName) {
        super(imageName);
    }

    public CouchbaseContainer withCredentials(String username, String password) {
        this.checkNotRunning();
        this.username = username;
        this.password = password;
        return this;
    }

    public CouchbaseContainer withBucket(BucketDefinition bucketDefinition) {
        this.checkNotRunning();
        this.buckets.add(bucketDefinition);
        return this;
    }

    public CouchbaseContainer withEnabledServices(CouchbaseService ... enabled) {
        this.checkNotRunning();
        this.enabledServices = EnumSet.copyOf(Arrays.asList(enabled));
        return this;
    }

    public final String getUsername() {
        return this.username;
    }

    public final String getPassword() {
        return this.password;
    }

    public int getBootstrapCarrierDirectPort() {
        return this.getMappedPort(11210);
    }

    public int getBootstrapHttpDirectPort() {
        return this.getMappedPort(8091);
    }

    public String getConnectionString() {
        return String.format("couchbase://%s:%d", this.getHost(), this.getBootstrapCarrierDirectPort());
    }

    protected void configure() {
        super.configure();
        WaitAllStrategy waitStrategy = new WaitAllStrategy();
        waitStrategy = waitStrategy.withStrategy((WaitStrategy)new HttpWaitStrategy().forPath("/pools/default").forPort(8091).withBasicCredentials(this.username, this.password).forStatusCode(200).forResponsePredicate(response -> {
            try {
                return Optional.of(MAPPER.readTree(response)).map(n -> n.at("/nodes/0/status")).map(JsonNode::asText).map("healthy"::equals).orElse(false);
            }
            catch (IOException e) {
                this.logger().error("Unable to parse response {}", response);
                return false;
            }
        }));
        if (this.enabledServices.contains((Object)CouchbaseService.QUERY)) {
            waitStrategy = waitStrategy.withStrategy((WaitStrategy)new HttpWaitStrategy().forPath("/admin/ping").forPort(8093).withBasicCredentials(this.username, this.password).forStatusCode(200));
        }
        this.waitingFor((WaitStrategy)waitStrategy);
    }

    protected void containerIsStarting(InspectContainerResponse containerInfo) {
        this.logger().debug("Couchbase container is starting, performing configuration.");
        this.waitUntilNodeIsOnline();
        this.renameNode();
        this.initializeServices();
        this.configureAdminUser();
        this.configureExternalPorts();
        if (this.enabledServices.contains((Object)CouchbaseService.INDEX)) {
            this.configureIndexer();
        }
    }

    protected void containerIsStarted(InspectContainerResponse containerInfo) {
        this.createBuckets();
        this.logger().info("Couchbase container is ready! UI available at http://{}:{}", (Object)this.getHost(), (Object)this.getMappedPort(8091));
    }

    private void waitUntilNodeIsOnline() {
        new HttpWaitStrategy().forPort(8091).forPath("/pools").forStatusCode(200).waitUntilReady((WaitStrategyTarget)this);
    }

    private void renameNode() {
        this.logger().debug("Renaming Couchbase Node from localhost to {}", (Object)this.getHost());
        Response response = this.doHttpRequest(8091, "/node/controller/rename", "POST", (RequestBody)new FormBody.Builder().add("hostname", this.getInternalIpAddress()).build(), false);
        try {
            this.checkSuccessfulResponse(response, "Could not rename couchbase node");
        }
        finally {
            if (Collections.singletonList(response).get(0) != null) {
                response.close();
            }
        }
    }

    private void initializeServices() {
        this.logger().debug("Initializing couchbase services on host: {}", this.enabledServices);
        String services = this.enabledServices.stream().map(s -> {
            switch (s) {
                case KV: {
                    return "kv";
                }
                case QUERY: {
                    return "n1ql";
                }
                case INDEX: {
                    return "index";
                }
                case SEARCH: {
                    return "fts";
                }
            }
            throw new IllegalStateException("Unknown service!");
        }).collect(Collectors.joining(","));
        Response response = this.doHttpRequest(8091, "/node/controller/setupServices", "POST", (RequestBody)new FormBody.Builder().add("services", services).build(), false);
        try {
            this.checkSuccessfulResponse(response, "Could not enable couchbase services");
        }
        finally {
            if (Collections.singletonList(response).get(0) != null) {
                response.close();
            }
        }
    }

    private void configureAdminUser() {
        this.logger().debug("Configuring couchbase admin user with username: \"{}\"", (Object)this.username);
        Response response = this.doHttpRequest(8091, "/settings/web", "POST", (RequestBody)new FormBody.Builder().add("username", this.username).add("password", this.password).add("port", Integer.toString(8091)).build(), false);
        try {
            this.checkSuccessfulResponse(response, "Could not configure couchbase admin user");
        }
        finally {
            if (Collections.singletonList(response).get(0) != null) {
                response.close();
            }
        }
    }

    private void configureExternalPorts() {
        this.logger().debug("Mapping external ports to the alternate address configuration");
        FormBody.Builder builder = new FormBody.Builder();
        builder.add("hostname", this.getHost());
        builder.add("mgmt", Integer.toString(this.getMappedPort(8091)));
        builder.add("mgmtSSL", Integer.toString(this.getMappedPort(18091)));
        if (this.enabledServices.contains((Object)CouchbaseService.KV)) {
            builder.add("kv", Integer.toString(this.getMappedPort(11210)));
            builder.add("kvSSL", Integer.toString(this.getMappedPort(11207)));
            builder.add("capi", Integer.toString(this.getMappedPort(8092)));
            builder.add("capiSSL", Integer.toString(this.getMappedPort(18092)));
        }
        if (this.enabledServices.contains((Object)CouchbaseService.QUERY)) {
            builder.add("n1ql", Integer.toString(this.getMappedPort(8093)));
            builder.add("n1qlSSL", Integer.toString(this.getMappedPort(18093)));
        }
        if (this.enabledServices.contains((Object)CouchbaseService.SEARCH)) {
            builder.add("fts", Integer.toString(this.getMappedPort(8094)));
            builder.add("ftsSSL", Integer.toString(this.getMappedPort(18094)));
        }
        Response response = this.doHttpRequest(8091, "/node/controller/setupAlternateAddresses/external", "PUT", (RequestBody)builder.build(), true);
        try {
            this.checkSuccessfulResponse(response, "Could not configure external ports");
        }
        finally {
            if (Collections.singletonList(response).get(0) != null) {
                response.close();
            }
        }
    }

    private void configureIndexer() {
        this.logger().debug("Configuring the indexer service");
        Response response = this.doHttpRequest(8091, "/settings/indexes", "POST", (RequestBody)new FormBody.Builder().add("storageMode", "memory_optimized").build(), true);
        try {
            this.checkSuccessfulResponse(response, "Could not configure the indexing service");
        }
        finally {
            if (Collections.singletonList(response).get(0) != null) {
                response.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createBuckets() {
        this.logger().debug("Creating " + this.buckets.size() + " buckets (and corresponding indexes).");
        for (BucketDefinition bucket : this.buckets) {
            this.logger().debug("Creating bucket \"" + bucket.getName() + "\"");
            Response response = this.doHttpRequest(8091, "/pools/default/buckets", "POST", (RequestBody)new FormBody.Builder().add("name", bucket.getName()).add("ramQuotaMB", Integer.toString(bucket.getQuota())).build(), true);
            try {
                this.checkSuccessfulResponse(response, "Could not create bucket " + bucket.getName());
                new HttpWaitStrategy().forPath("/pools/default/buckets/" + bucket.getName()).forPort(8091).withBasicCredentials(this.username, this.password).forStatusCode(200).waitUntilReady((WaitStrategyTarget)this);
                if (this.enabledServices.contains((Object)CouchbaseService.QUERY)) {
                    Unreliables.retryUntilTrue((int)1, (TimeUnit)TimeUnit.MINUTES, () -> {
                        Response queryResponse = this.doHttpRequest(8093, "/query/service", "POST", (RequestBody)new FormBody.Builder().add("statement", "SELECT COUNT(*) > 0 as present FROM system:keyspaces WHERE name = \"" + bucket.getName() + "\"").build(), true);
                        try {
                            String body = queryResponse.body() != null ? queryResponse.body().string() : null;
                            this.checkSuccessfulResponse(queryResponse, "Could not poll query service state for bucket: " + bucket.getName());
                            Boolean bl = Optional.of(MAPPER.readTree(body)).map(n -> n.at("/results/0/present")).map(JsonNode::asBoolean).orElse(false);
                            return bl;
                        }
                        finally {
                            if (Collections.singletonList(queryResponse).get(0) != null) {
                                queryResponse.close();
                            }
                        }
                    });
                }
                if (!bucket.hasPrimaryIndex()) continue;
                if (this.enabledServices.contains((Object)CouchbaseService.QUERY)) {
                    Response queryResponse = this.doHttpRequest(8093, "/query/service", "POST", (RequestBody)new FormBody.Builder().add("statement", "CREATE PRIMARY INDEX on `" + bucket.getName() + "`").build(), true);
                    try {
                        this.checkSuccessfulResponse(queryResponse, "Could not create primary index for bucket " + bucket.getName());
                        continue;
                    }
                    finally {
                        if (Collections.singletonList(queryResponse).get(0) != null) {
                            queryResponse.close();
                        }
                        continue;
                    }
                }
                this.logger().info("Primary index creation for bucket " + bucket.getName() + " ignored, since QUERY service is not present.");
            }
            finally {
                if (Collections.singletonList(response).get(0) == null) continue;
                response.close();
            }
        }
    }

    private String getInternalIpAddress() {
        return this.getContainerInfo().getNetworkSettings().getNetworks().values().stream().findFirst().map(ContainerNetwork::getIpAddress).orElseThrow(() -> new IllegalStateException("No network available to extract the internal IP from!"));
    }

    private void checkSuccessfulResponse(Response response, String message) {
        if (!response.isSuccessful()) {
            throw new IllegalStateException(message + ": " + response.toString());
        }
    }

    private void checkNotRunning() {
        if (this.isRunning()) {
            throw new IllegalStateException("Setter can only be called before the container is running");
        }
    }

    private Response doHttpRequest(int port, String path, String method, RequestBody body, boolean auth) {
        try {
            Request.Builder requestBuilder = new Request.Builder().url("http://" + this.getHost() + ":" + this.getMappedPort(port) + path);
            if (auth) {
                requestBuilder = requestBuilder.header("Authorization", Credentials.basic((String)this.username, (String)this.password));
            }
            requestBuilder = body == null ? requestBuilder.get() : requestBuilder.method(method, body);
            return HTTP_CLIENT.newCall(requestBuilder.build()).execute();
        }
        catch (Exception ex) {
            throw new RuntimeException("Could not perform request against couchbase HTTP endpoint ", ex);
        }
    }
}

