/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.couchbase;

import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.dockerjava.api.model.ContainerNetwork;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.rnorth.ducttape.unreliables.Unreliables;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.HttpWaitStrategy;
import org.testcontainers.containers.wait.strategy.WaitAllStrategy;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.containers.wait.strategy.WaitStrategyTarget;
import org.testcontainers.couchbase.BucketDefinition;
import org.testcontainers.couchbase.CouchbaseService;
import org.testcontainers.shaded.com.fasterxml.jackson.databind.JsonNode;
import org.testcontainers.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import org.testcontainers.shaded.okhttp3.Credentials;
import org.testcontainers.shaded.okhttp3.FormBody;
import org.testcontainers.shaded.okhttp3.OkHttpClient;
import org.testcontainers.shaded.okhttp3.Request;
import org.testcontainers.shaded.okhttp3.RequestBody;
import org.testcontainers.shaded.okhttp3.Response;
import org.testcontainers.utility.DockerImageName;

public class CouchbaseContainer
extends GenericContainer<CouchbaseContainer> {
    private static final int MGMT_PORT = 8091;
    private static final int MGMT_SSL_PORT = 18091;
    private static final int VIEW_PORT = 8092;
    private static final int VIEW_SSL_PORT = 18092;
    private static final int QUERY_PORT = 8093;
    private static final int QUERY_SSL_PORT = 18093;
    private static final int SEARCH_PORT = 8094;
    private static final int SEARCH_SSL_PORT = 18094;
    private static final int ANALYTICS_PORT = 8095;
    private static final int ANALYTICS_SSL_PORT = 18095;
    private static final int KV_PORT = 11210;
    private static final int KV_SSL_PORT = 11207;
    private static final DockerImageName DEFAULT_IMAGE_NAME = DockerImageName.parse((String)"couchbase/server");
    private static final String DEFAULT_TAG = "6.5.1";
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final OkHttpClient HTTP_CLIENT = new OkHttpClient();
    private String username = "Administrator";
    private String password = "password";
    private Set<CouchbaseService> enabledServices = EnumSet.of(CouchbaseService.KV, CouchbaseService.QUERY, CouchbaseService.SEARCH, CouchbaseService.INDEX);
    private final Map<CouchbaseService, Integer> customServiceQuotas = new HashMap<CouchbaseService, Integer>();
    private final List<BucketDefinition> buckets = new ArrayList<BucketDefinition>();
    private boolean isEnterprise = false;

    @Deprecated
    public CouchbaseContainer() {
        this(DEFAULT_IMAGE_NAME.withTag(DEFAULT_TAG));
    }

    public CouchbaseContainer(String dockerImageName) {
        this(DockerImageName.parse((String)dockerImageName));
    }

    public CouchbaseContainer(DockerImageName dockerImageName) {
        super(dockerImageName);
        dockerImageName.assertCompatibleWith(new DockerImageName[]{DEFAULT_IMAGE_NAME});
    }

    public CouchbaseContainer withCredentials(String username, String password) {
        this.checkNotRunning();
        this.username = username;
        this.password = password;
        return this;
    }

    public CouchbaseContainer withBucket(BucketDefinition bucketDefinition) {
        this.checkNotRunning();
        this.buckets.add(bucketDefinition);
        return this;
    }

    public CouchbaseContainer withEnabledServices(CouchbaseService ... enabled) {
        this.checkNotRunning();
        this.enabledServices = EnumSet.copyOf(Arrays.asList(enabled));
        return this;
    }

    public CouchbaseContainer withServiceQuota(CouchbaseService service, int quotaMb) {
        this.checkNotRunning();
        if (!service.hasQuota()) {
            throw new IllegalArgumentException("The provided service (" + (Object)((Object)service) + ") has no quota to configure");
        }
        if (quotaMb < service.getMinimumQuotaMb()) {
            throw new IllegalArgumentException("The custom quota (" + quotaMb + ") must not be smaller than the minimum quota for the service (" + service.getMinimumQuotaMb() + ")");
        }
        this.customServiceQuotas.put(service, quotaMb);
        return this;
    }

    public CouchbaseContainer withAnalyticsService() {
        this.checkNotRunning();
        this.enabledServices.add(CouchbaseService.ANALYTICS);
        return this;
    }

    public final String getUsername() {
        return this.username;
    }

    public final String getPassword() {
        return this.password;
    }

    public int getBootstrapCarrierDirectPort() {
        return this.getMappedPort(11210);
    }

    public int getBootstrapHttpDirectPort() {
        return this.getMappedPort(8091);
    }

    public String getConnectionString() {
        return String.format("couchbase://%s:%d", this.getHost(), this.getBootstrapCarrierDirectPort());
    }

    protected void configure() {
        super.configure();
        this.addExposedPorts(new int[]{8091, 18091, 8092, 18092, 8093, 18093, 8094, 18094, 8095, 18095, 11210, 11207});
        WaitAllStrategy waitStrategy = new WaitAllStrategy();
        waitStrategy = waitStrategy.withStrategy((WaitStrategy)new HttpWaitStrategy().forPath("/pools/default").forPort(8091).withBasicCredentials(this.username, this.password).forStatusCode(200).forResponsePredicate(response -> {
            try {
                return Optional.of(MAPPER.readTree(response)).map(n -> n.at("/nodes/0/status")).map(JsonNode::asText).map("healthy"::equals).orElse(false);
            }
            catch (IOException e) {
                this.logger().error("Unable to parse response: {}", response, (Object)e);
                return false;
            }
        }));
        if (this.enabledServices.contains((Object)CouchbaseService.QUERY)) {
            waitStrategy = waitStrategy.withStrategy((WaitStrategy)new HttpWaitStrategy().forPath("/admin/ping").forPort(8093).withBasicCredentials(this.username, this.password).forStatusCode(200));
        }
        if (this.enabledServices.contains((Object)CouchbaseService.ANALYTICS)) {
            waitStrategy = waitStrategy.withStrategy((WaitStrategy)new HttpWaitStrategy().forPath("/admin/ping").forPort(8095).withBasicCredentials(this.username, this.password).forStatusCode(200));
        }
        this.waitingFor((WaitStrategy)waitStrategy);
    }

    protected void containerIsStarting(InspectContainerResponse containerInfo) {
        this.logger().debug("Couchbase container is starting, performing configuration.");
        this.timePhase("waitUntilNodeIsOnline", this::waitUntilNodeIsOnline);
        this.timePhase("initializeIsEnterprise", this::initializeIsEnterprise);
        this.timePhase("renameNode", this::renameNode);
        this.timePhase("initializeServices", this::initializeServices);
        this.timePhase("setMemoryQuotas", this::setMemoryQuotas);
        this.timePhase("configureAdminUser", this::configureAdminUser);
        this.timePhase("configureExternalPorts", this::configureExternalPorts);
        if (this.enabledServices.contains((Object)CouchbaseService.INDEX)) {
            this.timePhase("configureIndexer", this::configureIndexer);
        }
    }

    protected void containerIsStarted(InspectContainerResponse containerInfo) {
        this.timePhase("createBuckets", this::createBuckets);
        this.logger().info("Couchbase container is ready! UI available at http://{}:{}", (Object)this.getHost(), (Object)this.getMappedPort(8091));
    }

    private void waitUntilNodeIsOnline() {
        new HttpWaitStrategy().forPort(8091).forPath("/pools").forStatusCode(200).waitUntilReady((WaitStrategyTarget)this);
    }

    private void initializeIsEnterprise() {
        Response response = this.doHttpRequest(8091, "/pools", "GET", null, true);
        try {
            try {
                this.isEnterprise = MAPPER.readTree(response.body().string()).get("isEnterprise").asBoolean();
            }
            catch (IOException e) {
                throw new IllegalStateException("Couchbase /pools did not return valid JSON");
            }
            if (!this.isEnterprise && this.enabledServices.contains((Object)CouchbaseService.ANALYTICS)) {
                throw new IllegalStateException("The Analytics Service is only supported with the Enterprise version");
            }
        }
        finally {
            if (Collections.singletonList(response).get(0) != null) {
                response.close();
            }
        }
    }

    private void renameNode() {
        this.logger().debug("Renaming Couchbase Node from localhost to {}", (Object)this.getHost());
        Response response = this.doHttpRequest(8091, "/node/controller/rename", "POST", (RequestBody)new FormBody.Builder().add("hostname", this.getInternalIpAddress()).build(), false);
        try {
            this.checkSuccessfulResponse(response, "Could not rename couchbase node");
        }
        finally {
            if (Collections.singletonList(response).get(0) != null) {
                response.close();
            }
        }
    }

    private void initializeServices() {
        this.logger().debug("Initializing couchbase services on host: {}", this.enabledServices);
        String services = this.enabledServices.stream().map(CouchbaseService::getIdentifier).collect(Collectors.joining(","));
        Response response = this.doHttpRequest(8091, "/node/controller/setupServices", "POST", (RequestBody)new FormBody.Builder().add("services", services).build(), false);
        try {
            this.checkSuccessfulResponse(response, "Could not enable couchbase services");
        }
        finally {
            if (Collections.singletonList(response).get(0) != null) {
                response.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setMemoryQuotas() {
        this.logger().debug("Custom service memory quotas: {}", this.customServiceQuotas);
        FormBody.Builder quotaBuilder = new FormBody.Builder();
        for (CouchbaseService service : this.enabledServices) {
            if (!service.hasQuota()) continue;
            int quota = this.customServiceQuotas.getOrDefault((Object)service, service.getMinimumQuotaMb());
            if (CouchbaseService.KV.equals((Object)service)) {
                quotaBuilder.add("memoryQuota", Integer.toString(quota));
                continue;
            }
            quotaBuilder.add(service.getIdentifier() + "MemoryQuota", Integer.toString(quota));
        }
        Response response = this.doHttpRequest(8091, "/pools/default", "POST", (RequestBody)quotaBuilder.build(), false);
        try {
            this.checkSuccessfulResponse(response, "Could not configure service memory quotas");
        }
        finally {
            if (Collections.singletonList(response).get(0) != null) {
                response.close();
            }
        }
    }

    private void configureAdminUser() {
        this.logger().debug("Configuring couchbase admin user with username: \"{}\"", (Object)this.username);
        Response response = this.doHttpRequest(8091, "/settings/web", "POST", (RequestBody)new FormBody.Builder().add("username", this.username).add("password", this.password).add("port", Integer.toString(8091)).build(), false);
        try {
            this.checkSuccessfulResponse(response, "Could not configure couchbase admin user");
        }
        finally {
            if (Collections.singletonList(response).get(0) != null) {
                response.close();
            }
        }
    }

    private void configureExternalPorts() {
        this.logger().debug("Mapping external ports to the alternate address configuration");
        FormBody.Builder builder = new FormBody.Builder();
        builder.add("hostname", this.getHost());
        builder.add("mgmt", Integer.toString(this.getMappedPort(8091)));
        builder.add("mgmtSSL", Integer.toString(this.getMappedPort(18091)));
        if (this.enabledServices.contains((Object)CouchbaseService.KV)) {
            builder.add("kv", Integer.toString(this.getMappedPort(11210)));
            builder.add("kvSSL", Integer.toString(this.getMappedPort(11207)));
            builder.add("capi", Integer.toString(this.getMappedPort(8092)));
            builder.add("capiSSL", Integer.toString(this.getMappedPort(18092)));
        }
        if (this.enabledServices.contains((Object)CouchbaseService.QUERY)) {
            builder.add("n1ql", Integer.toString(this.getMappedPort(8093)));
            builder.add("n1qlSSL", Integer.toString(this.getMappedPort(18093)));
        }
        if (this.enabledServices.contains((Object)CouchbaseService.SEARCH)) {
            builder.add("fts", Integer.toString(this.getMappedPort(8094)));
            builder.add("ftsSSL", Integer.toString(this.getMappedPort(18094)));
        }
        if (this.enabledServices.contains((Object)CouchbaseService.ANALYTICS)) {
            builder.add("cbas", Integer.toString(this.getMappedPort(8095)));
            builder.add("cbasSSL", Integer.toString(this.getMappedPort(18095)));
        }
        Response response = this.doHttpRequest(8091, "/node/controller/setupAlternateAddresses/external", "PUT", (RequestBody)builder.build(), true);
        try {
            this.checkSuccessfulResponse(response, "Could not configure external ports");
        }
        finally {
            if (Collections.singletonList(response).get(0) != null) {
                response.close();
            }
        }
    }

    private void configureIndexer() {
        this.logger().debug("Configuring the indexer service");
        Response response = this.doHttpRequest(8091, "/settings/indexes", "POST", (RequestBody)new FormBody.Builder().add("storageMode", this.isEnterprise ? "memory_optimized" : "forestdb").build(), true);
        try {
            this.checkSuccessfulResponse(response, "Could not configure the indexing service");
        }
        finally {
            if (Collections.singletonList(response).get(0) != null) {
                response.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createBuckets() {
        this.logger().debug("Creating {} buckets (and corresponding indexes).", (Object)this.buckets.size());
        for (BucketDefinition bucket : this.buckets) {
            this.logger().debug("Creating bucket \"{}\"", (Object)bucket.getName());
            Response response = this.doHttpRequest(8091, "/pools/default/buckets", "POST", (RequestBody)new FormBody.Builder().add("name", bucket.getName()).add("ramQuotaMB", Integer.toString(bucket.getQuota())).add("flushEnabled", bucket.hasFlushEnabled() ? "1" : "0").build(), true);
            try {
                this.checkSuccessfulResponse(response, "Could not create bucket " + bucket.getName());
                this.timePhase("createBucket:" + bucket.getName() + ":waitForAllServicesEnabled", () -> new HttpWaitStrategy().forPath("/pools/default/b/" + bucket.getName()).forPort(8091).withBasicCredentials(this.username, this.password).forStatusCode(200).forResponsePredicate((Predicate)new AllServicesEnabledPredicate()).waitUntilReady((WaitStrategyTarget)this));
                if (this.enabledServices.contains((Object)CouchbaseService.QUERY)) {
                    this.timePhase("createBucket:" + bucket.getName() + ":queryKeyspacePresent", () -> Unreliables.retryUntilTrue((int)1, (TimeUnit)TimeUnit.MINUTES, () -> {
                        Response queryResponse = this.doHttpRequest(8093, "/query/service", "POST", (RequestBody)new FormBody.Builder().add("statement", "SELECT COUNT(*) > 0 as present FROM system:keyspaces WHERE name = \"" + bucket.getName() + "\"").build(), true);
                        try {
                            String body = queryResponse.body() != null ? queryResponse.body().string() : null;
                            this.checkSuccessfulResponse(queryResponse, "Could not poll query service state for bucket: " + bucket.getName());
                            Boolean bl = Optional.of(MAPPER.readTree(body)).map(n -> n.at("/results/0/present")).map(JsonNode::asBoolean).orElse(false);
                            return bl;
                        }
                        finally {
                            if (Collections.singletonList(queryResponse).get(0) != null) {
                                queryResponse.close();
                            }
                        }
                    }));
                }
                if (!bucket.hasPrimaryIndex()) continue;
                if (this.enabledServices.contains((Object)CouchbaseService.QUERY)) {
                    Response queryResponse = this.doHttpRequest(8093, "/query/service", "POST", (RequestBody)new FormBody.Builder().add("statement", "CREATE PRIMARY INDEX on `" + bucket.getName() + "`").build(), true);
                    try {
                        block11: {
                            try {
                                this.checkSuccessfulResponse(queryResponse, "Could not create primary index for bucket " + bucket.getName());
                            }
                            catch (IllegalStateException ex) {
                                if (ex.getMessage().contains("Index creation will be retried in background")) break block11;
                                throw ex;
                            }
                        }
                        this.timePhase("createBucket:" + bucket.getName() + ":primaryIndexOnline", () -> Unreliables.retryUntilTrue((int)1, (TimeUnit)TimeUnit.MINUTES, () -> {
                            Response stateResponse = this.doHttpRequest(8093, "/query/service", "POST", (RequestBody)new FormBody.Builder().add("statement", "SELECT count(*) > 0 AS online FROM system:indexes where keyspace_id = \"" + bucket.getName() + "\" and is_primary = true and state = \"online\"").build(), true);
                            try {
                                String body = stateResponse.body() != null ? stateResponse.body().string() : null;
                                this.checkSuccessfulResponse(stateResponse, "Could not poll primary index state for bucket: " + bucket.getName());
                                Boolean bl = Optional.of(MAPPER.readTree(body)).map(n -> n.at("/results/0/online")).map(JsonNode::asBoolean).orElse(false);
                                return bl;
                            }
                            finally {
                                if (Collections.singletonList(stateResponse).get(0) != null) {
                                    stateResponse.close();
                                }
                            }
                        }));
                        continue;
                    }
                    finally {
                        if (Collections.singletonList(queryResponse).get(0) == null) continue;
                        queryResponse.close();
                        continue;
                    }
                }
                this.logger().info("Primary index creation for bucket {} ignored, since QUERY service is not present.", (Object)bucket.getName());
            }
            finally {
                if (Collections.singletonList(response).get(0) == null) continue;
                response.close();
            }
        }
    }

    private String getInternalIpAddress() {
        return this.getContainerInfo().getNetworkSettings().getNetworks().values().stream().findFirst().map(ContainerNetwork::getIpAddress).orElseThrow(() -> new IllegalStateException("No network available to extract the internal IP from!"));
    }

    private void checkSuccessfulResponse(Response response, String message) {
        if (!response.isSuccessful()) {
            String body = null;
            if (response.body() != null) {
                try {
                    body = response.body().string();
                }
                catch (IOException e) {
                    this.logger().debug("Unable to read body of response: {}", (Object)response, (Object)e);
                }
            }
            throw new IllegalStateException(message + ": " + response + ", body=" + (body == null ? "<null>" : body));
        }
    }

    private void checkNotRunning() {
        if (this.isRunning()) {
            throw new IllegalStateException("Setter can only be called before the container is running");
        }
    }

    private Response doHttpRequest(int port, String path, String method, RequestBody body, boolean auth) {
        try {
            Request.Builder requestBuilder = new Request.Builder().url("http://" + this.getHost() + ":" + this.getMappedPort(port) + path);
            if (auth) {
                requestBuilder = requestBuilder.header("Authorization", Credentials.basic((String)this.username, (String)this.password));
            }
            requestBuilder = body == null ? requestBuilder.get() : requestBuilder.method(method, body);
            return HTTP_CLIENT.newCall(requestBuilder.build()).execute();
        }
        catch (Exception ex) {
            throw new RuntimeException("Could not perform request against couchbase HTTP endpoint ", ex);
        }
    }

    private void timePhase(String name, Runnable toTime) {
        long start = System.nanoTime();
        toTime.run();
        long end = System.nanoTime();
        this.logger().debug("Phase {} took {}ms", (Object)name, (Object)TimeUnit.NANOSECONDS.toMillis(end - start));
    }

    private class AllServicesEnabledPredicate
    implements Predicate<String> {
        private AllServicesEnabledPredicate() {
        }

        @Override
        public boolean test(String rawConfig) {
            try {
                for (JsonNode node : MAPPER.readTree(rawConfig).at("/nodesExt")) {
                    for (CouchbaseService enabledService : CouchbaseContainer.this.enabledServices) {
                        boolean found = false;
                        Iterator fieldNames = node.get("services").fieldNames();
                        while (fieldNames.hasNext()) {
                            if (!((String)fieldNames.next()).startsWith(enabledService.getIdentifier())) continue;
                            found = true;
                        }
                        if (found) continue;
                        CouchbaseContainer.this.logger().trace("Service {} not yet part of config, retrying.", (Object)enabledService);
                        return false;
                    }
                }
                return true;
            }
            catch (IOException ex) {
                CouchbaseContainer.this.logger().error("Unable to parse response: {}", (Object)rawConfig, (Object)ex);
                return false;
            }
        }
    }
}

