/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.containers;

import com.github.dockerjava.api.DockerException;
import com.github.dockerjava.api.model.Container;
import java.util.Arrays;
import java.util.List;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.traits.LinkableContainer;

public class AmbassadorContainer
extends GenericContainer {
    private final String otherContainerName;
    private final String serviceName;
    private final int servicePort;

    public AmbassadorContainer(LinkableContainer otherContainer, String serviceName, int servicePort) {
        super("richnorth/ambassador:latest");
        this.otherContainerName = otherContainer.getContainerName();
        this.serviceName = serviceName;
        this.servicePort = servicePort;
        this.addLink(otherContainer, serviceName);
        this.addExposedPort(servicePort);
        this.addEnv("SERVICE_NAME", serviceName);
        this.addEnv("SERVICE_PORT", String.format("%d", servicePort));
    }

    public boolean isServiceReady() {
        try {
            List allContainers = (List)this.dockerClient.listContainersCmd().withShowAll(true).exec();
            for (Container container : allContainers) {
                if (!Arrays.asList(container.getNames()).contains("/" + this.otherContainerName) || container.getStatus().contains("Exited")) continue;
                return true;
            }
        }
        catch (DockerException e) {
            return false;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AmbassadorContainer)) {
            return false;
        }
        AmbassadorContainer other = (AmbassadorContainer)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$otherContainerName = this.getOtherContainerName();
        String other$otherContainerName = other.getOtherContainerName();
        if (this$otherContainerName == null ? other$otherContainerName != null : !this$otherContainerName.equals(other$otherContainerName)) {
            return false;
        }
        String this$serviceName = this.getServiceName();
        String other$serviceName = other.getServiceName();
        if (this$serviceName == null ? other$serviceName != null : !this$serviceName.equals(other$serviceName)) {
            return false;
        }
        return this.getServicePort() == other.getServicePort();
    }

    protected boolean canEqual(Object other) {
        return other instanceof AmbassadorContainer;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $otherContainerName = this.getOtherContainerName();
        result = result * 59 + ($otherContainerName == null ? 43 : $otherContainerName.hashCode());
        String $serviceName = this.getServiceName();
        result = result * 59 + ($serviceName == null ? 43 : $serviceName.hashCode());
        result = result * 59 + this.getServicePort();
        return result;
    }

    public String getOtherContainerName() {
        return this.otherContainerName;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public int getServicePort() {
        return this.servicePort;
    }

    public String toString() {
        return "AmbassadorContainer(otherContainerName=" + this.getOtherContainerName() + ", serviceName=" + this.getServiceName() + ", servicePort=" + this.getServicePort() + ")";
    }
}

