/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.containers;

import com.github.dockerjava.api.DockerException;
import com.github.dockerjava.api.model.Container;
import com.google.common.util.concurrent.Uninterruptibles;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.rnorth.ducttape.unreliables.Unreliables;
import org.slf4j.profiler.Profiler;
import org.testcontainers.containers.AmbassadorContainer;
import org.testcontainers.containers.BindMode;
import org.testcontainers.containers.FutureContainer;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.traits.LinkableContainer;
import org.testcontainers.utility.Base58;

public class DockerComposeContainer
extends GenericContainer
implements LinkableContainer {
    private final String identifier;
    private final Map<String, AmbassadorContainer> ambassadorContainers = new HashMap<String, AmbassadorContainer>();

    public DockerComposeContainer(File composeFile) {
        this(composeFile, "up -d");
    }

    public DockerComposeContainer(File composeFile, String command) {
        super("dduportal/docker-compose:1.3.1");
        this.identifier = Base58.randomString((int)6).toLowerCase();
        this.addEnv("COMPOSE_PROJECT_NAME", this.identifier);
        this.addEnv("COMPOSE_FILE", "/compose/" + composeFile.getAbsoluteFile().getName());
        this.addFileSystemBind(composeFile.getAbsoluteFile().getParentFile().getAbsolutePath(), "/compose", BindMode.READ_ONLY);
        this.addFileSystemBind("/var/run/docker.sock", "/docker.sock", BindMode.READ_WRITE);
        this.addEnv("DOCKER_HOST", "unix:///docker.sock");
        if (command != null) {
            this.setCommand(command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        for (Map.Entry<String, AmbassadorContainer> address : this.ambassadorContainers.entrySet()) {
            Profiler profiler = new Profiler("Docker compose container rule");
            profiler.setLogger(this.logger());
            profiler.start("Docker compose container startup");
            try {
                super.start();
                profiler.start("Ambassador container startup");
                AmbassadorContainer ambassadorContainer = address.getValue();
                Unreliables.retryUntilSuccess((int)120, (TimeUnit)TimeUnit.SECONDS, () -> {
                    Profiler localProfiler = profiler.startNested("Ambassador container: " + ambassadorContainer.getContainerName());
                    localProfiler.start("Start ambassador container");
                    try {
                        ambassadorContainer.start();
                        if (!ambassadorContainer.isRunning().booleanValue()) {
                            throw new IllegalStateException("Container startup aborted");
                        }
                    }
                    catch (Exception e) {
                        Uninterruptibles.sleepUninterruptibly((long)500L, (TimeUnit)TimeUnit.MILLISECONDS);
                        throw e;
                    }
                    return null;
                });
            }
            catch (Exception e) {
                this.logger().warn("Exception during ambassador container startup!", (Throwable)e);
            }
            finally {
                profiler.stop().log();
            }
        }
    }

    public void stop() {
        super.stop();
        this.ambassadorContainers.values().forEach(GenericContainer::stop);
        try {
            List containers = (List)this.dockerClient.listContainersCmd().withShowAll(true).exec();
            for (Container container : containers) {
                for (String name : container.getNames()) {
                    if (!name.startsWith("/" + this.identifier)) continue;
                    this.dockerClient.killContainerCmd(container.getId()).exec();
                    this.dockerClient.removeContainerCmd(container.getId()).exec();
                }
            }
        }
        catch (DockerException e) {
            this.logger().debug("Failed to stop a service container with exception", (Throwable)e);
        }
    }

    @Deprecated
    public GenericContainer withExposedPorts(Integer ... ports) {
        throw new UnsupportedOperationException("Use withExposedService instead");
    }

    public DockerComposeContainer withExposedService(String serviceName, int servicePort) {
        AmbassadorContainer ambassadorContainer = new AmbassadorContainer(new FutureContainer(this.identifier + "_" + serviceName), serviceName, servicePort);
        this.ambassadorContainers.put(serviceName + ":" + servicePort, ambassadorContainer);
        return this;
    }

    public String getServiceHost(String serviceName, Integer servicePort) {
        return this.ambassadorContainers.get(serviceName + ":" + servicePort).getIpAddress();
    }

    public Integer getServicePort(String serviceName, Integer servicePort) {
        return this.ambassadorContainers.get(serviceName + ":" + servicePort).getMappedPort(servicePort);
    }
}

