/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.elasticsearch;

import java.net.InetSocketAddress;
import java.time.Duration;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.HttpWaitStrategy;
import org.testcontainers.utility.Base58;
import org.testcontainers.utility.DockerImageName;

public class ElasticsearchContainer
extends GenericContainer<ElasticsearchContainer> {
    private static final int ELASTICSEARCH_DEFAULT_PORT = 9200;
    private static final int ELASTICSEARCH_DEFAULT_TCP_PORT = 9300;
    private static final DockerImageName DEFAULT_IMAGE_NAME = DockerImageName.parse((String)"docker.elastic.co/elasticsearch/elasticsearch");
    private static final DockerImageName DEFAULT_OSS_IMAGE_NAME = DockerImageName.parse((String)"docker.elastic.co/elasticsearch/elasticsearch-oss");
    protected static final String DEFAULT_TAG = "6.4.1";

    @Deprecated
    public ElasticsearchContainer() {
        this(DEFAULT_IMAGE_NAME.withTag(DEFAULT_TAG));
    }

    public ElasticsearchContainer(String dockerImageName) {
        this(DockerImageName.parse((String)dockerImageName));
    }

    public ElasticsearchContainer(DockerImageName dockerImageName) {
        super(dockerImageName);
        dockerImageName.assertCompatibleWith(new DockerImageName[]{DEFAULT_IMAGE_NAME, DEFAULT_OSS_IMAGE_NAME});
        this.logger().info("Starting an elasticsearch container using [{}]", (Object)dockerImageName);
        this.withNetworkAliases(new String[]{"elasticsearch-" + Base58.randomString((int)6)});
        this.withEnv("discovery.type", "single-node");
        this.addExposedPorts(new int[]{9200, 9300});
        this.setWaitStrategy(new HttpWaitStrategy().forPort(9200).forStatusCodeMatching(response -> response == 200 || response == 401).withStartupTimeout(Duration.ofMinutes(2L)));
    }

    public String getHttpHostAddress() {
        return this.getHost() + ":" + this.getMappedPort(9200);
    }

    public InetSocketAddress getTcpHost() {
        return new InetSocketAddress(this.getHost(), (int)this.getMappedPort(9300));
    }
}

