/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.elasticsearch;

import com.github.dockerjava.api.exception.NotFoundException;
import java.io.ByteArrayInputStream;
import java.net.InetSocketAddress;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.util.Optional;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.BindMode;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.LogMessageWaitStrategy;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.shaded.org.apache.commons.io.IOUtils;
import org.testcontainers.shaded.org.apache.commons.lang3.StringUtils;
import org.testcontainers.utility.ComparableVersion;
import org.testcontainers.utility.DockerImageName;

public class ElasticsearchContainer
extends GenericContainer<ElasticsearchContainer> {
    private static final Logger log = LoggerFactory.getLogger(ElasticsearchContainer.class);
    public static final String ELASTICSEARCH_DEFAULT_PASSWORD = "changeme";
    private static final int ELASTICSEARCH_DEFAULT_PORT = 9200;
    @Deprecated
    private static final int ELASTICSEARCH_DEFAULT_TCP_PORT = 9300;
    private static final DockerImageName DEFAULT_IMAGE_NAME = DockerImageName.parse((String)"docker.elastic.co/elasticsearch/elasticsearch");
    @Deprecated
    private static final DockerImageName DEFAULT_OSS_IMAGE_NAME = DockerImageName.parse((String)"docker.elastic.co/elasticsearch/elasticsearch-oss");
    private static final DockerImageName ELASTICSEARCH_IMAGE_NAME = DockerImageName.parse((String)"elasticsearch");
    private static final String DEFAULT_CERT_PATH = "/usr/share/elasticsearch/config/certs/http_ca.crt";
    @Deprecated
    protected static final String DEFAULT_TAG = "7.9.2";
    @Deprecated
    private boolean isOss = false;
    private final boolean isAtLeastMajorVersion8;
    private String certPath = "";

    @Deprecated
    public ElasticsearchContainer() {
        this(DEFAULT_IMAGE_NAME.withTag(DEFAULT_TAG));
    }

    public ElasticsearchContainer(String dockerImageName) {
        this(DockerImageName.parse((String)dockerImageName));
    }

    public ElasticsearchContainer(DockerImageName dockerImageName) {
        super(dockerImageName);
        dockerImageName.assertCompatibleWith(new DockerImageName[]{DEFAULT_IMAGE_NAME, DEFAULT_OSS_IMAGE_NAME, ELASTICSEARCH_IMAGE_NAME});
        if (dockerImageName.isCompatibleWith(DEFAULT_OSS_IMAGE_NAME)) {
            this.isOss = true;
            log.warn("{} is not supported anymore after 7.10.2. Please switch to {}", (Object)dockerImageName.getUnversionedPart(), (Object)DEFAULT_IMAGE_NAME.getUnversionedPart());
        }
        this.withEnv("discovery.type", "single-node");
        this.withEnv("cluster.routing.allocation.disk.threshold_enabled", "false");
        this.withClasspathResourceMapping("elasticsearch-default-memory-vm.options", "/usr/share/elasticsearch/config/jvm.options.d/ elasticsearch-default-memory-vm.options", BindMode.READ_ONLY);
        this.addExposedPorts(new int[]{9200, 9300});
        this.isAtLeastMajorVersion8 = new ComparableVersion(dockerImageName.getVersionPart()).isGreaterThanOrEqualTo("8.0.0");
        String regex = ".*(\"message\":\\s?\"started[\\s?|\"].*|] started\n$)";
        this.setWaitStrategy((WaitStrategy)new LogMessageWaitStrategy().withRegEx(regex));
        if (this.isAtLeastMajorVersion8) {
            this.withPassword(ELASTICSEARCH_DEFAULT_PASSWORD);
            this.withCertPath(DEFAULT_CERT_PATH);
        }
    }

    public Optional<byte[]> caCertAsBytes() {
        if (StringUtils.isBlank((CharSequence)this.certPath)) {
            return Optional.empty();
        }
        try {
            byte[] bytes = (byte[])this.copyFileFromContainer(this.certPath, IOUtils::toByteArray);
            if (bytes.length > 0) {
                return Optional.of(bytes);
            }
        }
        catch (NotFoundException e) {
            log.warn("CA cert under " + this.certPath + " not found.");
        }
        return Optional.empty();
    }

    public SSLContext createSslContextFromCa() {
        try {
            CertificateFactory factory = CertificateFactory.getInstance("X.509");
            Certificate trustedCa = factory.generateCertificate(new ByteArrayInputStream(this.caCertAsBytes().orElseThrow(() -> new IllegalStateException("CA cert under " + this.certPath + " not found."))));
            KeyStore trustStore = KeyStore.getInstance("pkcs12");
            trustStore.load(null, null);
            trustStore.setCertificateEntry("ca", trustedCa);
            SSLContext sslContext = SSLContext.getInstance("TLSv1.3");
            TrustManagerFactory tmfactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmfactory.init(trustStore);
            sslContext.init(null, tmfactory.getTrustManagers(), null);
            return sslContext;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public ElasticsearchContainer withPassword(String password) {
        if (this.isOss) {
            throw new IllegalArgumentException("You can not activate security on Elastic OSS Image. Please switch to the default distribution");
        }
        this.withEnv("ELASTIC_PASSWORD", password);
        if (!this.isAtLeastMajorVersion8) {
            this.withEnv("xpack.security.enabled", "true");
        }
        return this;
    }

    public ElasticsearchContainer withCertPath(String certPath) {
        this.certPath = certPath;
        return this;
    }

    public String getHttpHostAddress() {
        return this.getHost() + ":" + this.getMappedPort(9200);
    }

    @Deprecated
    public InetSocketAddress getTcpHost() {
        return new InetSocketAddress(this.getHost(), (int)this.getMappedPort(9300));
    }
}

