/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.grafana;

import com.github.dockerjava.api.command.InspectContainerResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.utility.DockerImageName;

public class LgtmStackContainer
extends GenericContainer<LgtmStackContainer> {
    private static final Logger log = LoggerFactory.getLogger(LgtmStackContainer.class);
    private static final DockerImageName DEFAULT_IMAGE_NAME = DockerImageName.parse((String)"grafana/otel-lgtm");
    private static final int GRAFANA_PORT = 3000;
    private static final int OTLP_GRPC_PORT = 4317;
    private static final int OTLP_HTTP_PORT = 4318;
    private static final int PROMETHEUS_PORT = 9090;

    public LgtmStackContainer(String image) {
        this(DockerImageName.parse((String)image));
    }

    public LgtmStackContainer(DockerImageName image) {
        super(image);
        image.assertCompatibleWith(new DockerImageName[]{DEFAULT_IMAGE_NAME});
        this.withExposedPorts(new Integer[]{3000, 4317, 4318, 9090});
        this.waitingFor((WaitStrategy)Wait.forLogMessage((String)".*The OpenTelemetry collector and the Grafana LGTM stack are up and running.*\\s", (int)1));
    }

    protected void containerIsStarted(InspectContainerResponse containerInfo) {
        log.info("Access to the Grafana dashboard: {}", (Object)this.getGrafanaHttpUrl());
    }

    public String getOtlpGrpcUrl() {
        return "http://" + this.getHost() + ":" + this.getMappedPort(4317);
    }

    public String getOtlpHttpUrl() {
        return "http://" + this.getHost() + ":" + this.getMappedPort(4318);
    }

    public String getPromehteusHttpUrl() {
        return "http://" + this.getHost() + ":" + this.getMappedPort(9090);
    }

    public String getGrafanaHttpUrl() {
        return "http://" + this.getHost() + ":" + this.getMappedPort(3000);
    }
}

