/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.hivemq;

import java.io.File;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.ContainerLaunchException;
import org.testcontainers.shaded.javassist.ClassPool;
import org.testcontainers.shaded.javassist.NotFoundException;
import org.testcontainers.shaded.org.apache.commons.io.FileUtils;
import org.testcontainers.shaded.org.jboss.shrinkwrap.api.ExtensionLoader;
import org.testcontainers.shaded.org.jboss.shrinkwrap.api.ShrinkWrap;
import org.testcontainers.shaded.org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.testcontainers.shaded.org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.testcontainers.shaded.org.jboss.shrinkwrap.impl.base.exporter.zip.ZipExporterImpl;
import org.testcontainers.shaded.org.jboss.shrinkwrap.impl.base.spec.JavaArchiveImpl;

public class HiveMQExtension {
    private static final String VALID_EXTENSION_XML = "<hivemq-extension>   <id>%s</id>   <name>%s</name>   <version>%s</version>   <priority>%s</priority>   <start-priority>%s</start-priority></hivemq-extension>";
    private static final String EXTENSION_MAIN_CLASS_NAME = "com.hivemq.extension.sdk.api.ExtensionMain";
    private static final Logger LOGGER = LoggerFactory.getLogger(HiveMQExtension.class);
    @NotNull
    private final String id;
    @NotNull
    private final String name;
    @NotNull
    private final String version;
    private final int priority;
    private final int startPriority;
    private final boolean disabledOnStartup;
    @NotNull
    private final Class<?> mainClass;
    @NotNull
    private final List<Class<?>> additionalClasses;

    private HiveMQExtension(@NotNull String id, @NotNull String name, @NotNull String version, int priority, int startPriority, boolean disabledOnStartup, @NotNull Class<?> mainClass, @NotNull List<Class<?>> additionalClasses) {
        this.id = id;
        this.name = name;
        this.version = version;
        this.priority = priority;
        this.startPriority = startPriority;
        this.disabledOnStartup = disabledOnStartup;
        this.mainClass = mainClass;
        this.additionalClasses = additionalClasses;
    }

    @NotNull
    File createExtension(@NotNull HiveMQExtension hiveMQExtension) throws Exception {
        File disabled;
        boolean newFile;
        File tempDir = Files.createTempDirectory("", new FileAttribute[0]).toFile();
        File extensionDir = new File(tempDir, hiveMQExtension.getId());
        FileUtils.writeStringToFile((File)new File(extensionDir, "hivemq-extension.xml"), (String)String.format(VALID_EXTENSION_XML, hiveMQExtension.getId(), hiveMQExtension.getName(), hiveMQExtension.getVersion(), hiveMQExtension.getPriority(), hiveMQExtension.getStartPriority()), (Charset)Charset.defaultCharset());
        if (hiveMQExtension.isDisabledOnStartup() && !(newFile = (disabled = new File(extensionDir, "DISABLED")).createNewFile())) {
            throw new ContainerLaunchException("Could not create DISABLED file '" + disabled.getAbsolutePath() + "' on host machine.");
        }
        ExtensionLoader extensionLoader = ShrinkWrap.getDefaultDomain().getConfiguration().getExtensionLoader();
        extensionLoader.addOverride(JavaArchive.class, JavaArchiveImpl.class);
        extensionLoader.addOverride(ZipExporter.class, ZipExporterImpl.class);
        JavaArchive javaArchive = (JavaArchive)ShrinkWrap.create(JavaArchive.class).addAsServiceProvider(EXTENSION_MAIN_CLASS_NAME, hiveMQExtension.getMainClass().getName());
        this.putSubclassesIntoJar(hiveMQExtension.getId(), hiveMQExtension.getMainClass(), javaArchive);
        for (Class<?> additionalClass : hiveMQExtension.getAdditionalClasses()) {
            javaArchive.addClass(additionalClass);
            this.putSubclassesIntoJar(hiveMQExtension.getId(), additionalClass, javaArchive);
        }
        javaArchive.as(ZipExporter.class).exportTo(new File(extensionDir, "extension.jar"));
        return extensionDir;
    }

    private void putSubclassesIntoJar(@NotNull String extensionId, @Nullable Class<?> clazz, @NotNull JavaArchive javaArchive) throws NotFoundException {
        if (clazz != null) {
            Set<String> subClassNames = ClassPool.getDefault().get(clazz.getName()).getClassFile().getConstPool().getClassNames();
            for (String subClassName : subClassNames) {
                String className = subClassName.replaceAll("/", ".");
                if (!className.startsWith("[L")) {
                    LOGGER.debug("Trying to package subclass '{}' into extension '{}'.", (Object)className, (Object)extensionId);
                    javaArchive.addClass(className);
                    continue;
                }
                LOGGER.debug("Class '{}' will be ignored.", (Object)className);
            }
        }
    }

    @NotNull
    public List<Class<?>> getAdditionalClasses() {
        return Collections.unmodifiableList(this.additionalClasses);
    }

    @NotNull
    public static Builder builder() {
        return new Builder();
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public String getVersion() {
        return this.version;
    }

    public int getPriority() {
        return this.priority;
    }

    public int getStartPriority() {
        return this.startPriority;
    }

    public boolean isDisabledOnStartup() {
        return this.disabledOnStartup;
    }

    @NotNull
    public Class<?> getMainClass() {
        return this.mainClass;
    }

    public static final class Builder {
        @Nullable
        private String id;
        @Nullable
        private String name;
        @Nullable
        private String version;
        private int priority = 0;
        private int startPriority = 0;
        private boolean disabledOnStartup = false;
        @Nullable
        private Class<?> mainClass;
        @NotNull
        private final LinkedList<Class<?>> additionalClasses = new LinkedList();

        @NotNull
        public HiveMQExtension build() {
            if (this.id == null || this.id.isEmpty()) {
                throw new IllegalArgumentException("extension id must not be null or empty");
            }
            if (this.name == null || this.name.isEmpty()) {
                throw new IllegalArgumentException("extension name must not be null or empty");
            }
            if (this.version == null || this.version.isEmpty()) {
                throw new IllegalArgumentException("extension version must not be null or empty");
            }
            if (this.mainClass == null) {
                throw new IllegalArgumentException("extension main class must not be null");
            }
            return new HiveMQExtension(this.id, this.name, this.version, this.priority, this.startPriority, this.disabledOnStartup, this.mainClass, this.additionalClasses);
        }

        @NotNull
        public Builder id(@NotNull String id) {
            this.id = id;
            return this;
        }

        @NotNull
        public Builder name(@NotNull String name) {
            this.name = name;
            return this;
        }

        @NotNull
        public Builder version(@NotNull String version) {
            this.version = version;
            return this;
        }

        @NotNull
        public Builder priority(int priority) {
            this.priority = priority;
            return this;
        }

        @NotNull
        public Builder startPriority(int startPriority) {
            this.startPriority = startPriority;
            return this;
        }

        @NotNull
        public Builder disabledOnStartup(boolean disabledOnStartup) {
            this.disabledOnStartup = disabledOnStartup;
            return this;
        }

        @NotNull
        public Builder mainClass(@NotNull Class<?> mainClass) {
            try {
                Class<?> extensionMain = Class.forName(HiveMQExtension.EXTENSION_MAIN_CLASS_NAME);
                if (!extensionMain.isAssignableFrom(mainClass)) {
                    throw new IllegalArgumentException("The provided class does not implement 'com.hivemq.extension.sdk.api.ExtensionMain'");
                }
                this.mainClass = mainClass;
                return this;
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException("The class 'com.hivemq.extension.sdk.api.ExtensionMain' was not found in the classpath.");
            }
        }

        @NotNull
        public Builder addAdditionalClass(@NotNull Class<?> clazz) {
            this.additionalClasses.add(clazz);
            return this;
        }
    }
}

