/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.shaded.net.lingala.zip4j.tasks;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.testcontainers.shaded.net.lingala.zip4j.exception.ZipException;
import org.testcontainers.shaded.net.lingala.zip4j.headers.HeaderWriter;
import org.testcontainers.shaded.net.lingala.zip4j.model.Zip4jConfig;
import org.testcontainers.shaded.net.lingala.zip4j.model.ZipModel;
import org.testcontainers.shaded.net.lingala.zip4j.model.ZipParameters;
import org.testcontainers.shaded.net.lingala.zip4j.progress.ProgressMonitor;
import org.testcontainers.shaded.net.lingala.zip4j.tasks.AbstractAddFileToZipTask;
import org.testcontainers.shaded.net.lingala.zip4j.tasks.AbstractZipTaskParameters;
import org.testcontainers.shaded.net.lingala.zip4j.tasks.AsyncZipTask;

public class AddFilesToZipTask
extends AbstractAddFileToZipTask<AddFilesToZipTaskParameters> {
    public AddFilesToZipTask(ZipModel zipModel, char[] password, HeaderWriter headerWriter, AsyncZipTask.AsyncTaskParameters asyncTaskParameters) {
        super(zipModel, password, headerWriter, asyncTaskParameters);
    }

    @Override
    protected void executeTask(AddFilesToZipTaskParameters taskParameters, ProgressMonitor progressMonitor) throws IOException {
        this.verifyZipParameters(taskParameters.zipParameters);
        this.addFilesToZip(taskParameters.filesToAdd, progressMonitor, taskParameters.zipParameters, taskParameters.zip4jConfig);
    }

    @Override
    protected long calculateTotalWork(AddFilesToZipTaskParameters taskParameters) throws ZipException {
        return this.calculateWorkForFiles(taskParameters.filesToAdd, taskParameters.zipParameters);
    }

    @Override
    protected ProgressMonitor.Task getTask() {
        return super.getTask();
    }

    public static class AddFilesToZipTaskParameters
    extends AbstractZipTaskParameters {
        private final List<File> filesToAdd;
        private final ZipParameters zipParameters;

        public AddFilesToZipTaskParameters(List<File> filesToAdd, ZipParameters zipParameters, Zip4jConfig zip4jConfig) {
            super(zip4jConfig);
            this.filesToAdd = filesToAdd;
            this.zipParameters = zipParameters;
        }
    }
}

