/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.shaded.org.jboss.shrinkwrap.api;

import java.io.File;
import org.testcontainers.shaded.org.jboss.shrinkwrap.api.Assignable;
import org.testcontainers.shaded.org.jboss.shrinkwrap.api.Configuration;
import org.testcontainers.shaded.org.jboss.shrinkwrap.api.ConfigurationBuilder;
import org.testcontainers.shaded.org.jboss.shrinkwrap.api.Domain;
import org.testcontainers.shaded.org.jboss.shrinkwrap.api.UnknownExtensionTypeException;
import org.testcontainers.shaded.org.jboss.shrinkwrap.api.importer.ArchiveImportException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ShrinkWrap {
    private ShrinkWrap() {
        throw new UnsupportedOperationException("No instances permitted");
    }

    public static Domain createDomain() {
        return ShrinkWrap.createDomain(new ConfigurationBuilder());
    }

    public static Domain createDomain(ConfigurationBuilder builder) throws IllegalArgumentException {
        if (builder == null) {
            throw new IllegalArgumentException("builder must be supplied");
        }
        return ShrinkWrap.createDomain(builder.build());
    }

    public static Domain createDomain(Configuration configuration) throws IllegalArgumentException {
        if (configuration == null) {
            throw new IllegalArgumentException("configuration must be supplied");
        }
        return new Domain(configuration);
    }

    public static Domain getDefaultDomain() {
        return DefaultDomainWrapper.SINGLETON.getDefaultDomain();
    }

    public static <T extends Assignable> T create(Class<T> type) throws IllegalArgumentException, UnknownExtensionTypeException {
        if (type == null) {
            throw new IllegalArgumentException("Type must be specified");
        }
        return ShrinkWrap.getDefaultDomain().getArchiveFactory().create(type);
    }

    public static <T extends Assignable> T create(Class<T> type, String archiveName) throws IllegalArgumentException {
        if (type == null) {
            throw new IllegalArgumentException("Type must be specified");
        }
        if (archiveName == null || archiveName.length() == 0) {
            throw new IllegalArgumentException("ArchiveName must be specified");
        }
        return ShrinkWrap.getDefaultDomain().getArchiveFactory().create(type, archiveName);
    }

    public static <T extends Assignable> T createFromZipFile(Class<T> type, File archiveFile) throws IllegalArgumentException, ArchiveImportException {
        return ShrinkWrap.getDefaultDomain().getArchiveFactory().createFromZipFile(type, archiveFile);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum DefaultDomainWrapper {
        SINGLETON;

        private transient Domain domain = ShrinkWrap.createDomain();

        private Domain getDefaultDomain() {
            return this.domain;
        }
    }
}

