/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.hivemq;

import com.github.dockerjava.api.command.InspectContainerResponse;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;
import org.testcontainers.containers.ContainerLaunchException;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.LogMessageWaitStrategy;
import org.testcontainers.containers.wait.strategy.WaitAllStrategy;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.hivemq.HiveMQExtension;
import org.testcontainers.hivemq.PathUtil;
import org.testcontainers.shaded.org.apache.commons.io.FileUtils;
import org.testcontainers.utility.DockerImageName;
import org.testcontainers.utility.MountableFile;

public class HiveMQContainer
extends GenericContainer<HiveMQContainer> {
    private static final Logger LOGGER = LoggerFactory.getLogger(HiveMQContainer.class);
    private static final DockerImageName DEFAULT_HIVEMQ_EE_IMAGE_NAME = DockerImageName.parse((String)"hivemq/hivemq4");
    private static final DockerImageName DEFAULT_HIVEMQ_CE_IMAGE_NAME = DockerImageName.parse((String)"hivemq/hivemq-ce");
    private static final int DEBUGGING_PORT = 9000;
    private static final int MQTT_PORT = 1883;
    private static final int CONTROL_CENTER_PORT = 8080;
    private static final int MODE = 511;
    @NotNull
    private static final Pattern EXTENSION_ID_PATTERN = Pattern.compile("<id>(.+?)</id>");
    @NotNull
    private final ConcurrentHashMap<String, CountDownLatch> containerOutputLatches = new ConcurrentHashMap();
    private boolean controlCenterEnabled = false;
    private boolean debugging = false;
    @NotNull
    private final Set<String> prepackagedExtensionsToRemove = new HashSet<String>();
    private boolean removeAllPrepackagedExtensions = false;
    @NotNull
    private final WaitAllStrategy waitStrategy = new WaitAllStrategy();

    public HiveMQContainer(@NotNull DockerImageName dockerImageName) {
        super(dockerImageName);
        dockerImageName.assertCompatibleWith(new DockerImageName[]{DEFAULT_HIVEMQ_CE_IMAGE_NAME, DEFAULT_HIVEMQ_EE_IMAGE_NAME});
        this.addExposedPort(1883);
        this.waitStrategy.withStrategy((WaitStrategy)new LogMessageWaitStrategy().withRegEx("(.*)Started HiveMQ in(.*)"));
        this.waitingFor((WaitStrategy)this.waitStrategy);
        this.withLogConsumer(outputFrame -> {
            String utf8String = outputFrame.getUtf8String();
            if (this.debugging && utf8String.startsWith("Listening for transport dt_socket at address:")) {
                System.out.println("Listening for transport dt_socket at address: " + this.getMappedPort(9000));
            }
            if (!this.containerOutputLatches.isEmpty()) {
                this.containerOutputLatches.forEach((regEx, latch) -> {
                    if (outputFrame.getUtf8String().matches("(?s)" + regEx)) {
                        LOGGER.debug("Container Output '{}' matched RegEx '{}'", (Object)utf8String, regEx);
                        latch.countDown();
                    } else {
                        LOGGER.debug("Container Output '{}' did not match RegEx '{}'", (Object)utf8String, regEx);
                    }
                });
            }
        });
        HashMap<String, String> tmpFs = new HashMap<String, String>();
        if (dockerImageName.isCompatibleWith(DEFAULT_HIVEMQ_EE_IMAGE_NAME)) {
            tmpFs.put("/opt/hivemq/audit", "rw");
            tmpFs.put("/opt/hivemq/backup", "rw");
        }
        tmpFs.put("/opt/hivemq/log", "rw");
        tmpFs.put("/opt/hivemq/data", "rw");
        this.withTmpFs(tmpFs);
    }

    protected void configure() {
        this.withCreateContainerCmdModifier(it -> it.withEntrypoint(new String[]{"/bin/sh"}));
        String removeCommand = this.removeAllPrepackagedExtensions || !this.prepackagedExtensionsToRemove.isEmpty() ? (this.removeAllPrepackagedExtensions ? "rm -rf /opt/hivemq/extensions/** &&" : this.prepackagedExtensionsToRemove.stream().map(extensionId -> "rm -rf /opt/hivemq/extensions/" + extensionId + "&&").collect(Collectors.joining())) : "";
        this.setCommand(new String[]{"-c", removeCommand + "cp -r '/opt/hivemq/temp-extensions/'* /opt/hivemq/extensions/ ; chmod -R 777 /opt/hivemq/extensions ; /opt/docker-entrypoint.sh /opt/hivemq/bin/run.sh"});
    }

    protected void containerIsStarted(@NotNull InspectContainerResponse containerInfo) {
        if (this.controlCenterEnabled) {
            LOGGER.info("The HiveMQ Control Center is reachable under: http://{}:{}", (Object)this.getHost(), (Object)this.getMappedPort(8080));
        }
    }

    @NotNull
    public HiveMQContainer waitForExtension(@NotNull String extensionName) {
        String regEX = "(.*)Extension \"" + extensionName + "\" version (.*) started successfully(.*)";
        this.waitStrategy.withStrategy((WaitStrategy)new LogMessageWaitStrategy().withRegEx(regEX));
        return (HiveMQContainer)this.self();
    }

    @NotNull
    public HiveMQContainer waitForExtension(@NotNull HiveMQExtension extension) {
        return this.waitForExtension(extension.getName());
    }

    @NotNull
    public HiveMQContainer withDebugging() {
        this.debugging = true;
        this.addExposedPorts(new int[]{9000});
        this.withEnv("JAVA_OPTS", "-agentlib:jdwp=transport=dt_socket,address=0.0.0.0:9000,server=y,suspend=y");
        return (HiveMQContainer)this.self();
    }

    @NotNull
    public HiveMQContainer withLogLevel(@NotNull Level level) {
        this.withEnv("HIVEMQ_LOG_LEVEL", level.name());
        return (HiveMQContainer)this.self();
    }

    @NotNull
    public HiveMQContainer withExtension(@NotNull HiveMQExtension hiveMQExtension) {
        try {
            File extension = hiveMQExtension.createExtension(hiveMQExtension);
            MountableFile mountableExtension = MountableFile.forHostPath((String)extension.getPath(), (Integer)511);
            this.withCopyFileToContainer(mountableExtension, "/opt/hivemq/temp-extensions/" + hiveMQExtension.getId());
        }
        catch (Exception e) {
            throw new ContainerLaunchException(e.getMessage() == null ? "" : e.getMessage(), (Throwable)e);
        }
        return (HiveMQContainer)this.self();
    }

    @NotNull
    public HiveMQContainer withExtension(@NotNull MountableFile mountableExtension) {
        File extensionDir = new File(mountableExtension.getResolvedPath());
        if (!extensionDir.exists()) {
            throw new ContainerLaunchException("Extension '" + mountableExtension.getFilesystemPath() + "' could not be mounted. It does not exist.");
        }
        if (!extensionDir.isDirectory()) {
            throw new ContainerLaunchException("Extension '" + mountableExtension.getFilesystemPath() + "' could not be mounted. It is not a directory.");
        }
        try {
            String extensionDirName = this.getExtensionDirectoryName(extensionDir);
            String containerPath = "/opt/hivemq/temp-extensions/" + extensionDirName;
            this.withCopyFileToContainer(this.cloneWithFileMode(mountableExtension), containerPath);
            LOGGER.info("Putting extension '{}' into '{}'", (Object)extensionDirName, (Object)containerPath);
        }
        catch (Exception e) {
            throw new ContainerLaunchException(e.getMessage() == null ? "" : e.getMessage(), (Throwable)e);
        }
        return (HiveMQContainer)this.self();
    }

    @NotNull
    private String getExtensionDirectoryName(@NotNull File extensionDirectory) throws IOException {
        File file = new File(extensionDirectory, "hivemq-extension.xml");
        String xml = FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8);
        Matcher matcher = EXTENSION_ID_PATTERN.matcher(xml);
        if (!matcher.find()) {
            throw new IllegalStateException("Could not parse extension id from '" + file.getAbsolutePath() + "'");
        }
        return matcher.group(1);
    }

    @NotNull
    public HiveMQContainer withoutPrepackagedExtensions(String ... extensionIds) {
        Collections.addAll(this.prepackagedExtensionsToRemove, extensionIds);
        return (HiveMQContainer)this.self();
    }

    @NotNull
    public HiveMQContainer withoutPrepackagedExtensions() {
        this.removeAllPrepackagedExtensions = true;
        return (HiveMQContainer)this.self();
    }

    @NotNull
    public HiveMQContainer withLicense(@NotNull MountableFile mountableLicense) {
        File licenseFile = new File(mountableLicense.getResolvedPath());
        if (!licenseFile.exists()) {
            throw new ContainerLaunchException("License file '" + mountableLicense.getFilesystemPath() + "' does not exist.");
        }
        if (!licenseFile.getName().endsWith(".lic") && !licenseFile.getName().endsWith(".elic")) {
            throw new ContainerLaunchException("License file '" + mountableLicense.getFilesystemPath() + "' does not end wit '.lic' or '.elic'.");
        }
        String containerPath = "/opt/hivemq/license/" + licenseFile.getName();
        this.withCopyFileToContainer(this.cloneWithFileMode(mountableLicense), containerPath);
        LOGGER.info("Putting license '{}' into '{}'.", (Object)licenseFile.getAbsolutePath(), (Object)containerPath);
        return (HiveMQContainer)this.self();
    }

    @NotNull
    public HiveMQContainer withHiveMQConfig(@NotNull MountableFile mountableConfig) {
        File config = new File(mountableConfig.getResolvedPath());
        if (!config.exists()) {
            throw new ContainerLaunchException("HiveMQ config file '" + mountableConfig.getFilesystemPath() + "' does not exist.");
        }
        String containerPath = "/opt/hivemq/conf/config.xml";
        this.withCopyFileToContainer(this.cloneWithFileMode(mountableConfig), "/opt/hivemq/conf/config.xml");
        LOGGER.info("Putting '{}' into '{}'.", (Object)config.getAbsolutePath(), (Object)"/opt/hivemq/conf/config.xml");
        return (HiveMQContainer)this.self();
    }

    @NotNull
    public HiveMQContainer withFileInExtensionHomeFolder(@NotNull MountableFile file, @NotNull String extensionId) {
        return this.withFileInExtensionHomeFolder(file, extensionId, "");
    }

    @NotNull
    public HiveMQContainer withFileInExtensionHomeFolder(@NotNull MountableFile file, @NotNull String extensionId, @NotNull String pathInExtensionHome) {
        return this.withFileInHomeFolder(file, "/temp-extensions/" + extensionId + PathUtil.prepareAppendPath(pathInExtensionHome));
    }

    @NotNull
    public HiveMQContainer withFileInHomeFolder(@NotNull MountableFile mountableFile, @NotNull String pathInHomeFolder) {
        File file = new File(mountableFile.getResolvedPath());
        if (pathInHomeFolder.trim().isEmpty()) {
            throw new ContainerLaunchException("pathInHomeFolder must not be empty");
        }
        if (!file.exists()) {
            throw new ContainerLaunchException("File '" + mountableFile.getFilesystemPath() + "' does not exist.");
        }
        String containerPath = "/opt/hivemq" + PathUtil.prepareAppendPath(pathInHomeFolder);
        this.withCopyFileToContainer(this.cloneWithFileMode(mountableFile), containerPath);
        LOGGER.info("Putting file '{}' into container path '{}'.", (Object)file.getAbsolutePath(), (Object)containerPath);
        return (HiveMQContainer)this.self();
    }

    public void disableExtension(@NotNull String extensionName, @NotNull String extensionDirectory, @NotNull Duration timeout) throws TimeoutException {
        String regEX = "(.*)Extension \"" + extensionName + "\" version (.*) stopped successfully(.*)";
        try {
            String containerPath = "/opt/hivemq/extensions" + PathUtil.prepareInnerPath(extensionDirectory) + "DISABLED";
            CountDownLatch latch = new CountDownLatch(1);
            this.containerOutputLatches.put(regEX, latch);
            this.execInContainer(new String[]{"touch", containerPath});
            LOGGER.info("Putting DISABLED file into container path '{}'", (Object)containerPath);
            boolean await = latch.await(timeout.getSeconds(), TimeUnit.SECONDS);
            if (!await) {
                throw new TimeoutException("Extension disabling timed out after '" + timeout.getSeconds() + "' seconds. Maybe you are using a HiveMQ Community Edition image, which does not support disabling of extensions");
            }
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.containerOutputLatches.remove(regEX);
        }
    }

    public void disableExtension(@NotNull String extensionName, @NotNull String extensionDirectory) throws TimeoutException {
        this.disableExtension(extensionName, extensionDirectory, Duration.ofSeconds(60L));
    }

    public void disableExtension(@NotNull HiveMQExtension hiveMQExtension, @NotNull Duration timeout) throws TimeoutException {
        this.disableExtension(hiveMQExtension.getName(), hiveMQExtension.getId(), timeout);
    }

    public void disableExtension(@NotNull HiveMQExtension hiveMQExtension) throws TimeoutException {
        this.disableExtension(hiveMQExtension, Duration.ofSeconds(60L));
    }

    public void enableExtension(@NotNull String extensionName, @NotNull String extensionDirectory, @NotNull Duration timeout) throws TimeoutException {
        String regEX = "(.*)Extension \"" + extensionName + "\" version (.*) started successfully(.*)";
        try {
            String containerPath = "/opt/hivemq/extensions" + PathUtil.prepareInnerPath(extensionDirectory) + "DISABLED";
            CountDownLatch latch = new CountDownLatch(1);
            this.containerOutputLatches.put(regEX, latch);
            this.execInContainer(new String[]{"rm", "-rf", containerPath});
            LOGGER.info("Removing DISABLED file in container path '{}'", (Object)containerPath);
            boolean await = latch.await(timeout.getSeconds(), TimeUnit.SECONDS);
            if (!await) {
                throw new TimeoutException("Extension enabling timed out after '" + timeout.getSeconds() + "' seconds. Maybe you are using a HiveMQ Community Edition image, which does not support disabling of extensions");
            }
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.containerOutputLatches.remove(regEX);
        }
    }

    public void enableExtension(@NotNull String extensionName, @NotNull String extensionDirectory) throws TimeoutException {
        this.enableExtension(extensionName, extensionDirectory, Duration.ofSeconds(60L));
    }

    public void enableExtension(@NotNull HiveMQExtension hiveMQExtension, @NotNull Duration timeout) throws TimeoutException {
        this.enableExtension(hiveMQExtension.getName(), hiveMQExtension.getId(), timeout);
    }

    public void enableExtension(@NotNull HiveMQExtension hiveMQExtension) throws TimeoutException {
        this.enableExtension(hiveMQExtension, Duration.ofSeconds(60L));
    }

    @NotNull
    public HiveMQContainer withControlCenter() {
        this.addExposedPorts(new int[]{8080});
        this.controlCenterEnabled = true;
        return (HiveMQContainer)this.self();
    }

    public int getMqttPort() {
        return this.getMappedPort(1883);
    }

    @NotNull
    private MountableFile cloneWithFileMode(@NotNull MountableFile mountableFile) {
        return MountableFile.forHostPath((String)mountableFile.getResolvedPath(), (Integer)511);
    }
}

