/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.containers;

import java.util.Collections;
import java.util.Set;
import org.influxdb.InfluxDB;
import org.influxdb.InfluxDBFactory;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitAllStrategy;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.utility.DockerImageName;

public class InfluxDBContainer<SELF extends InfluxDBContainer<SELF>>
extends GenericContainer<SELF> {
    public static final Integer INFLUXDB_PORT = 8086;
    private static final DockerImageName DEFAULT_IMAGE_NAME = DockerImageName.parse((String)"influxdb");
    private static final String DEFAULT_TAG = "1.4.3";
    @Deprecated
    public static final String VERSION = "1.4.3";
    private boolean authEnabled = true;
    private String admin = "admin";
    private String adminPassword = "password";
    private String database;
    private String username = "any";
    private String password = "any";

    @Deprecated
    public InfluxDBContainer() {
        this(DEFAULT_IMAGE_NAME.withTag("1.4.3"));
    }

    @Deprecated
    public InfluxDBContainer(String version) {
        this(DEFAULT_IMAGE_NAME.withTag(version));
    }

    public InfluxDBContainer(DockerImageName dockerImageName) {
        super(dockerImageName);
        dockerImageName.assertCompatibleWith(new DockerImageName[]{DEFAULT_IMAGE_NAME});
        this.waitStrategy = new WaitAllStrategy().withStrategy((WaitStrategy)Wait.forHttp((String)"/ping").withBasicCredentials(this.username, this.password).forStatusCode(204)).withStrategy((WaitStrategy)Wait.forListeningPort());
        this.addExposedPort(INFLUXDB_PORT);
    }

    protected void configure() {
        this.addEnv("INFLUXDB_ADMIN_USER", this.admin);
        this.addEnv("INFLUXDB_ADMIN_PASSWORD", this.adminPassword);
        this.addEnv("INFLUXDB_HTTP_AUTH_ENABLED", String.valueOf(this.authEnabled));
        this.addEnv("INFLUXDB_DB", this.database);
        this.addEnv("INFLUXDB_USER", this.username);
        this.addEnv("INFLUXDB_USER_PASSWORD", this.password);
    }

    public Set<Integer> getLivenessCheckPortNumbers() {
        return Collections.singleton(this.getMappedPort(INFLUXDB_PORT));
    }

    public SELF withAuthEnabled(boolean authEnabled) {
        this.authEnabled = authEnabled;
        return (SELF)((Object)((InfluxDBContainer)this.self()));
    }

    public SELF withAdmin(String admin) {
        this.admin = admin;
        return (SELF)((Object)((InfluxDBContainer)this.self()));
    }

    public SELF withAdminPassword(String adminPassword) {
        this.adminPassword = adminPassword;
        return (SELF)((Object)((InfluxDBContainer)this.self()));
    }

    public SELF withDatabase(String database) {
        this.database = database;
        return (SELF)((Object)((InfluxDBContainer)this.self()));
    }

    public SELF withUsername(String username) {
        this.username = username;
        return (SELF)((Object)((InfluxDBContainer)this.self()));
    }

    public SELF withPassword(String password) {
        this.password = password;
        return (SELF)((Object)((InfluxDBContainer)this.self()));
    }

    public String getUrl() {
        return "http://" + this.getHost() + ":" + this.getLivenessCheckPort();
    }

    public InfluxDB getNewInfluxDB() {
        InfluxDB influxDB = InfluxDBFactory.connect((String)this.getUrl(), (String)this.username, (String)this.password);
        influxDB.setDatabase(this.database);
        return influxDB;
    }
}

