/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.containers;

import java.net.URL;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.testcontainers.containers.ContainerLaunchException;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.traits.LinkableContainer;
import org.testcontainers.utility.Retryables;

public abstract class JdbcDatabaseContainer
extends GenericContainer
implements LinkableContainer {
    private static final Object DRIVER_LOAD_MUTEX = new Object();
    private Driver driver;
    protected Map<String, String> parameters = new HashMap<String, String>();

    public JdbcDatabaseContainer(String dockerImageName) {
        super(dockerImageName);
    }

    public abstract String getName();

    protected abstract String getDriverClassName();

    public abstract String getJdbcUrl();

    public abstract String getUsername();

    public abstract String getPassword();

    protected abstract String getTestQueryString();

    protected void waitUntilContainerStarted() {
        Retryables.retryUntilSuccess((int)120, (TimeUnit)TimeUnit.SECONDS, (Retryables.UnreliableSupplier)new Retryables.UnreliableSupplier<Connection>(){

            public Connection get() throws Exception {
                JdbcDatabaseContainer.this.checkContainerNotAborted();
                Connection connection = JdbcDatabaseContainer.this.createConnection("");
                boolean success = connection.createStatement().execute(JdbcDatabaseContainer.this.getTestQueryString());
                if (success) {
                    JdbcDatabaseContainer.this.logger().info("Obtained a connection to container ({})", (Object)JdbcDatabaseContainer.this.getJdbcUrl());
                    return connection;
                }
                throw new SQLException("Failed to execute test query");
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Driver getJdbcDriverInstance() {
        Object object = DRIVER_LOAD_MUTEX;
        synchronized (object) {
            if (this.driver == null) {
                try {
                    this.driver = (Driver)ClassLoader.getSystemClassLoader().loadClass(this.getDriverClassName()).newInstance();
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                    throw new RuntimeException("Could not get Driver", e);
                }
            }
        }
        return this.driver;
    }

    public Connection createConnection(String queryString) throws SQLException {
        Properties info = new Properties();
        info.put("user", this.getUsername());
        info.put("password", this.getPassword());
        return this.getJdbcDriverInstance().connect(this.getJdbcUrl() + queryString, info);
    }

    protected void optionallyMapResourceParameterAsVolume(String paramName, String pathNameInContainer) {
        if (this.parameters.containsKey(paramName)) {
            String resourceName = this.parameters.get(paramName);
            URL classPathResource = ClassLoader.getSystemClassLoader().getResource(resourceName);
            if (classPathResource == null) {
                throw new ContainerLaunchException("Could not locate a classpath resource for " + paramName + " of " + resourceName);
            }
            this.addFileSystemBind(classPathResource.getFile(), pathNameInContainer, GenericContainer.BindMode.READ_ONLY);
        }
    }

    protected abstract String getLivenessCheckPort();

    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    public void addParameter(String paramName, String value) {
        this.parameters.put(paramName, value);
    }
}

