/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.core;

import com.github.dockerjava.api.exception.DockerClientException;
import com.github.dockerjava.core.SSLConfig;
import com.github.dockerjava.core.util.CertificateUtils;
import java.io.Serializable;
import java.security.Security;
import javax.net.ssl.SSLContext;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.glassfish.jersey.SslConfigurator;
import org.testcontainers.shaded.com.google.common.base.Preconditions;

public class LocalDirectorySSLConfig
implements SSLConfig,
Serializable {
    private static final long serialVersionUID = -4736328026418377358L;
    private final String dockerCertPath;

    public LocalDirectorySSLConfig(String dockerCertPath) {
        Preconditions.checkNotNull(dockerCertPath);
        this.dockerCertPath = dockerCertPath;
    }

    public String getDockerCertPath() {
        return this.dockerCertPath;
    }

    @Override
    public SSLContext getSSLContext() {
        boolean certificatesExist = CertificateUtils.verifyCertificatesExist(this.dockerCertPath);
        if (certificatesExist) {
            try {
                Security.addProvider(new BouncyCastleProvider());
                String httpProtocols = System.getProperty("https.protocols");
                System.setProperty("https.protocols", "TLSv1");
                SslConfigurator sslConfig = SslConfigurator.newInstance(true);
                if (httpProtocols != null) {
                    System.setProperty("https.protocols", httpProtocols);
                }
                sslConfig.keyStore(CertificateUtils.createKeyStore(this.dockerCertPath));
                sslConfig.keyStorePassword("docker");
                sslConfig.trustStore(CertificateUtils.createTrustStore(this.dockerCertPath));
                return sslConfig.createSSLContext();
            }
            catch (Exception e) {
                throw new DockerClientException(e.getMessage(), e);
            }
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LocalDirectorySSLConfig that = (LocalDirectorySSLConfig)o;
        return this.dockerCertPath.equals(that.dockerCertPath);
    }

    public int hashCode() {
        return this.dockerCertPath.hashCode();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{" + "dockerCertPath=" + this.dockerCertPath + "}";
    }
}

