/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.shaded.javax.ws.rs.client;

import java.lang.annotation.Annotation;
import java.util.Locale;
import org.testcontainers.shaded.javax.ws.rs.core.Form;
import org.testcontainers.shaded.javax.ws.rs.core.MediaType;
import org.testcontainers.shaded.javax.ws.rs.core.MultivaluedMap;
import org.testcontainers.shaded.javax.ws.rs.core.Variant;

public final class Entity<T> {
    private static final Annotation[] EMPTY_ANNOTATIONS = new Annotation[0];
    private final T entity;
    private final Variant variant;
    private final Annotation[] annotations;

    public static <T> Entity<T> entity(T entity, MediaType mediaType) {
        return new Entity<T>(entity, mediaType);
    }

    public static <T> Entity<T> entity(T entity, MediaType mediaType, Annotation[] annotations) {
        return new Entity<T>(entity, mediaType, annotations);
    }

    public static <T> Entity<T> entity(T entity, String mediaType) {
        return new Entity<T>(entity, MediaType.valueOf(mediaType));
    }

    public static <T> Entity<T> entity(T entity, Variant variant) {
        return new Entity<T>(entity, variant);
    }

    public static <T> Entity<T> entity(T entity, Variant variant, Annotation[] annotations) {
        return new Entity<T>(entity, variant, annotations);
    }

    public static <T> Entity<T> text(T entity) {
        return new Entity<T>(entity, MediaType.TEXT_PLAIN_TYPE);
    }

    public static <T> Entity<T> xml(T entity) {
        return new Entity<T>(entity, MediaType.APPLICATION_XML_TYPE);
    }

    public static <T> Entity<T> json(T entity) {
        return new Entity<T>(entity, MediaType.APPLICATION_JSON_TYPE);
    }

    public static <T> Entity<T> html(T entity) {
        return new Entity<T>(entity, MediaType.TEXT_HTML_TYPE);
    }

    public static <T> Entity<T> xhtml(T entity) {
        return new Entity<T>(entity, MediaType.APPLICATION_XHTML_XML_TYPE);
    }

    public static Entity<Form> form(Form form) {
        return new Entity<Form>(form, MediaType.APPLICATION_FORM_URLENCODED_TYPE);
    }

    public static Entity<Form> form(MultivaluedMap<String, String> formData) {
        return new Entity<Form>(new Form(formData), MediaType.APPLICATION_FORM_URLENCODED_TYPE);
    }

    private Entity(T entity, MediaType mediaType) {
        this(entity, new Variant(mediaType, (Locale)null, null), EMPTY_ANNOTATIONS);
    }

    private Entity(T entity, Variant variant) {
        this(entity, variant, EMPTY_ANNOTATIONS);
    }

    private Entity(T entity, MediaType mediaType, Annotation[] annotations) {
        this(entity, new Variant(mediaType, (Locale)null, null), annotations);
    }

    private Entity(T entity, Variant variant, Annotation[] annotations) {
        this.entity = entity;
        this.variant = variant;
        this.annotations = annotations;
    }

    public Variant getVariant() {
        return this.variant;
    }

    public MediaType getMediaType() {
        return this.variant.getMediaType();
    }

    public String getEncoding() {
        return this.variant.getEncoding();
    }

    public Locale getLanguage() {
        return this.variant.getLanguage();
    }

    public T getEntity() {
        return this.entity;
    }

    public Annotation[] getAnnotations() {
        return this.annotations;
    }
}

