/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.shaded.jersey.repackaged.com.google.common.collect;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.testcontainers.shaded.javax.annotation.Nullable;
import org.testcontainers.shaded.jersey.repackaged.com.google.common.base.Function;
import org.testcontainers.shaded.jersey.repackaged.com.google.common.base.Preconditions;
import org.testcontainers.shaded.jersey.repackaged.com.google.common.collect.ByFunctionOrdering;
import org.testcontainers.shaded.jersey.repackaged.com.google.common.collect.ComparatorOrdering;
import org.testcontainers.shaded.jersey.repackaged.com.google.common.collect.ImmutableList;
import org.testcontainers.shaded.jersey.repackaged.com.google.common.collect.Iterables;
import org.testcontainers.shaded.jersey.repackaged.com.google.common.collect.Lists;
import org.testcontainers.shaded.jersey.repackaged.com.google.common.collect.NaturalOrdering;
import org.testcontainers.shaded.jersey.repackaged.com.google.common.collect.ReverseOrdering;

public abstract class Ordering<T>
implements Comparator<T> {
    public static <C extends Comparable> Ordering<C> natural() {
        return NaturalOrdering.INSTANCE;
    }

    public static <T> Ordering<T> from(Comparator<T> comparator) {
        return comparator instanceof Ordering ? (Ordering<T>)comparator : new ComparatorOrdering<T>(comparator);
    }

    protected Ordering() {
    }

    public <S extends T> Ordering<S> reverse() {
        return new ReverseOrdering(this);
    }

    public <F> Ordering<F> onResultOf(Function<F, ? extends T> function) {
        return new ByFunctionOrdering<F, T>(function, this);
    }

    @Override
    public abstract int compare(@Nullable T var1, @Nullable T var2);

    public <E extends T> List<E> sortedCopy(Iterable<E> iterable) {
        Object[] array = Iterables.toArray(iterable);
        Arrays.sort(array, this);
        return Lists.newArrayList(Arrays.asList(array));
    }

    public <E extends T> ImmutableList<E> immutableSortedCopy(Iterable<E> iterable) {
        Object[] elements;
        for (Object e : elements = Iterables.toArray(iterable)) {
            Preconditions.checkNotNull(e);
        }
        Arrays.sort(elements, this);
        return ImmutableList.asImmutableList(elements);
    }
}

