/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.shaded.org.apache.http.client.protocol;

import java.io.IOException;
import org.testcontainers.shaded.org.apache.http.HttpEntity;
import org.testcontainers.shaded.org.apache.http.HttpEntityEnclosingRequest;
import org.testcontainers.shaded.org.apache.http.HttpException;
import org.testcontainers.shaded.org.apache.http.HttpRequest;
import org.testcontainers.shaded.org.apache.http.HttpRequestInterceptor;
import org.testcontainers.shaded.org.apache.http.HttpVersion;
import org.testcontainers.shaded.org.apache.http.ProtocolVersion;
import org.testcontainers.shaded.org.apache.http.annotation.Immutable;
import org.testcontainers.shaded.org.apache.http.client.config.RequestConfig;
import org.testcontainers.shaded.org.apache.http.client.protocol.HttpClientContext;
import org.testcontainers.shaded.org.apache.http.protocol.HttpContext;
import org.testcontainers.shaded.org.apache.http.util.Args;

@Immutable
public class RequestExpectContinue
implements HttpRequestInterceptor {
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        if (!request.containsHeader("Expect") && request instanceof HttpEntityEnclosingRequest) {
            HttpClientContext clientContext;
            RequestConfig config;
            ProtocolVersion ver = request.getRequestLine().getProtocolVersion();
            HttpEntity entity = ((HttpEntityEnclosingRequest)request).getEntity();
            if (entity != null && entity.getContentLength() != 0L && !ver.lessEquals(HttpVersion.HTTP_1_0) && (config = (clientContext = HttpClientContext.adapt(context)).getRequestConfig()).isExpectContinueEnabled()) {
                request.addHeader("Expect", "100-continue");
            }
        }
    }
}

