/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.shaded.org.apache.http.impl.conn;

import java.io.IOException;
import java.io.InputStream;
import org.testcontainers.shaded.org.apache.http.annotation.NotThreadSafe;
import org.testcontainers.shaded.org.apache.http.impl.conn.Wire;

@NotThreadSafe
class LoggingInputStream
extends InputStream {
    private final InputStream in;
    private final Wire wire;

    public LoggingInputStream(InputStream in, Wire wire) {
        this.in = in;
        this.wire = wire;
    }

    public int read() throws IOException {
        int b = this.in.read();
        if (b != -1) {
            this.wire.input(b);
        }
        return b;
    }

    public int read(byte[] b) throws IOException {
        int bytesRead = this.in.read(b);
        if (bytesRead != -1) {
            this.wire.input(b, 0, bytesRead);
        }
        return bytesRead;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int bytesRead = this.in.read(b, off, len);
        if (bytesRead != -1) {
            this.wire.input(b, off, bytesRead);
        }
        return bytesRead;
    }

    public long skip(long n) throws IOException {
        return super.skip(n);
    }

    public int available() throws IOException {
        return this.in.available();
    }

    public synchronized void mark(int readlimit) {
        super.mark(readlimit);
    }

    public synchronized void reset() throws IOException {
        super.reset();
    }

    public boolean markSupported() {
        return false;
    }

    public void close() throws IOException {
        this.in.close();
    }
}

