/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.shaded.org.glassfish.jersey.message.internal;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import org.testcontainers.shaded.javax.inject.Singleton;
import org.testcontainers.shaded.javax.ws.rs.Consumes;
import org.testcontainers.shaded.javax.ws.rs.Produces;
import org.testcontainers.shaded.javax.ws.rs.core.MediaType;
import org.testcontainers.shaded.javax.ws.rs.core.MultivaluedMap;
import org.testcontainers.shaded.org.glassfish.jersey.message.internal.AbstractMessageReaderWriterProvider;
import org.testcontainers.shaded.org.glassfish.jersey.message.internal.EntityInputStream;

@Produces(value={"text/plain", "*/*"})
@Consumes(value={"text/plain", "*/*"})
@Singleton
public final class ReaderProvider
extends AbstractMessageReaderWriterProvider<Reader> {
    @Override
    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return Reader.class == type;
    }

    @Override
    public Reader readFrom(Class<Reader> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream inputStream) throws IOException {
        EntityInputStream entityStream = EntityInputStream.create(inputStream);
        if (entityStream.isEmpty()) {
            return new BufferedReader(new InputStreamReader(new ByteArrayInputStream(new byte[0])));
        }
        return new BufferedReader(new InputStreamReader((InputStream)entityStream, ReaderProvider.getCharset(mediaType)));
    }

    @Override
    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return Reader.class.isAssignableFrom(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeTo(Reader t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException {
        try {
            OutputStreamWriter out = new OutputStreamWriter(entityStream, ReaderProvider.getCharset(mediaType));
            ReaderProvider.writeTo(t, out);
            out.flush();
        }
        finally {
            t.close();
        }
    }
}

