/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.shaded.org.jvnet.hk2.internal;

import java.lang.reflect.Method;
import javassist.util.proxy.MethodHandler;
import org.testcontainers.shaded.org.glassfish.hk2.api.ActiveDescriptor;
import org.testcontainers.shaded.org.glassfish.hk2.api.Context;
import org.testcontainers.shaded.org.glassfish.hk2.api.MultiException;
import org.testcontainers.shaded.org.glassfish.hk2.api.ServiceHandle;
import org.testcontainers.shaded.org.glassfish.hk2.utilities.reflection.ReflectionHelper;
import org.testcontainers.shaded.org.jvnet.hk2.internal.ServiceLocatorImpl;

public class MethodInterceptorImpl
implements MethodHandler {
    private static final String PROXY_MORE_METHOD_NAME = "__make";
    private final ServiceLocatorImpl locator;
    private final ActiveDescriptor<?> descriptor;
    private final ServiceHandle<?> root;

    MethodInterceptorImpl(ServiceLocatorImpl sli, ActiveDescriptor<?> descriptor, ServiceHandle<?> root) {
        this.locator = sli;
        this.descriptor = descriptor;
        this.root = root;
    }

    @Override
    public Object invoke(Object target, Method method, Method proceed, Object[] params) throws Throwable {
        Context<?> context = this.locator.resolveContext(this.descriptor.getScopeAnnotation());
        Object service = context.findOrCreate(this.descriptor, this.root);
        if (service == null) {
            throw new MultiException(new IllegalStateException("Proxiable context " + context + " findOrCreate returned a null for descriptor " + this.descriptor + " and handle " + this.root));
        }
        if (method.getName().equals(PROXY_MORE_METHOD_NAME)) {
            return service;
        }
        return ReflectionHelper.invoke(service, method, params, this.locator.getNeutralContextClassLoader());
    }
}

