/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.api.model;

import com.github.dockerjava.api.model.AccessMode;
import com.github.dockerjava.api.model.Volume;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.testcontainers.shaded.com.fasterxml.jackson.core.JsonGenerator;
import org.testcontainers.shaded.com.fasterxml.jackson.core.JsonParser;
import org.testcontainers.shaded.com.fasterxml.jackson.core.JsonProcessingException;
import org.testcontainers.shaded.com.fasterxml.jackson.core.ObjectCodec;
import org.testcontainers.shaded.com.fasterxml.jackson.databind.DeserializationContext;
import org.testcontainers.shaded.com.fasterxml.jackson.databind.JsonDeserializer;
import org.testcontainers.shaded.com.fasterxml.jackson.databind.JsonNode;
import org.testcontainers.shaded.com.fasterxml.jackson.databind.JsonSerializer;
import org.testcontainers.shaded.com.fasterxml.jackson.databind.SerializerProvider;
import org.testcontainers.shaded.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.testcontainers.shaded.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import org.testcontainers.shaded.com.fasterxml.jackson.databind.node.NullNode;

@JsonDeserialize(using=Deserializer.class)
@JsonSerialize(using=Serializer.class)
@Deprecated
public class VolumeRW {
    private Volume volume;
    private AccessMode accessMode = AccessMode.rw;

    public VolumeRW(Volume volume) {
        this.volume = volume;
    }

    public VolumeRW(Volume volume, AccessMode accessMode) {
        this.volume = volume;
        this.accessMode = accessMode;
    }

    public Volume getVolume() {
        return this.volume;
    }

    public AccessMode getAccessMode() {
        return this.accessMode;
    }

    public String toString() {
        return this.getVolume() + ":" + (Object)((Object)this.getAccessMode());
    }

    public boolean equals(Object obj) {
        if (obj instanceof VolumeRW) {
            VolumeRW other = (VolumeRW)obj;
            return new EqualsBuilder().append(this.getVolume(), other.getVolume()).append((Object)this.accessMode, (Object)other.getAccessMode()).isEquals();
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.getVolume()).append((Object)this.getAccessMode()).toHashCode();
    }

    public static class Deserializer
    extends JsonDeserializer<VolumeRW> {
        @Override
        public VolumeRW deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            ObjectCodec oc = jsonParser.getCodec();
            JsonNode node = (JsonNode)oc.readTree(jsonParser);
            if (!node.equals(NullNode.getInstance())) {
                Map.Entry<String, JsonNode> field = node.fields().next();
                String volume = field.getKey();
                AccessMode accessMode = AccessMode.fromBoolean(field.getValue().asBoolean());
                return new VolumeRW(new Volume(volume), accessMode);
            }
            return null;
        }
    }

    public static class Serializer
    extends JsonSerializer<VolumeRW> {
        @Override
        public void serialize(VolumeRW volumeRW, JsonGenerator jsonGen, SerializerProvider serProvider) throws IOException, JsonProcessingException {
            jsonGen.writeStartObject();
            jsonGen.writeFieldName(volumeRW.getVolume().getPath());
            jsonGen.writeString(Boolean.toString(volumeRW.getAccessMode().toBoolean()));
            jsonGen.writeEndObject();
        }
    }
}

